/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.HashMap;

final class HttpMethodSpec {
    private static Object[] methodKeys;
    private static int mapSize;
    private static HashMap methodHash;
    private static String allActions;
    private static int allSet;
    private static String[] methodSetArray;

    private HttpMethodSpec() {
    }

    static int getMethodSet(String actions) {
        if (actions == null || actions.equals("")) {
            return allSet;
        }
        return HttpMethodSpec.makeMethodSet(actions);
    }

    static int getMethodSet(String[] methods) {
        if (methods == null || methods.length == 0) {
            return allSet;
        }
        return HttpMethodSpec.makeMethodSet(methods);
    }

    private static int makeMethodSet(String actions) {
        int i = 0;
        int mSet = 0;
        int comma = 0;
        while (comma >= 0 && i < actions.length()) {
            comma = actions.indexOf(",", i);
            if (comma != 0) {
                Integer bit = comma < 0 ? (Integer)methodHash.get(actions.substring(i)) : (Integer)methodHash.get(actions.substring(i, comma));
                if (bit == null) {
                    throw new IllegalArgumentException("illegal HTTP method");
                }
                mSet |= bit.intValue();
                i = comma + 1;
                continue;
            }
            throw new IllegalArgumentException("illegal HTTP method Spec");
        }
        return mSet;
    }

    private static int makeMethodSet(String[] methods) {
        int mSet = 0;
        for (int i = 0; i < methods.length; ++i) {
            Integer bit = (Integer)methodHash.get(methods[i]);
            if (bit == null) {
                throw new IllegalArgumentException("illegal HTTP method");
            }
            mSet |= bit.intValue();
        }
        return mSet;
    }

    static String getActions(int methodSet) {
        if (methodSet == allSet) {
            return null;
        }
        if (methodSetArray[methodSet] == null) {
            int bitValue = 1;
            StringBuffer actions = null;
            for (int i = 0; i < mapSize; ++i) {
                if ((methodSet & bitValue) == bitValue) {
                    if (actions == null) {
                        actions = new StringBuffer("");
                    } else {
                        actions.append(",");
                    }
                    actions.append((String)methodKeys[i]);
                }
                bitValue *= 2;
            }
            if (actions != null) {
                HttpMethodSpec.methodSetArray[methodSet] = actions.toString();
            } else {
                throw new IllegalArgumentException("invalid methodSet");
            }
        }
        return methodSetArray[methodSet];
    }

    static boolean implies(int thisMethodSet, int thatMethodSet) {
        return (thisMethodSet & thatMethodSet) == thatMethodSet;
    }

    static {
        int i;
        methodKeys = new Object[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
        mapSize = methodKeys.length;
        methodHash = new HashMap();
        int b = 1;
        for (i = 0; i < mapSize; ++i) {
            methodHash.put(methodKeys[i], new Integer(b));
            b <<= 1;
        }
        StringBuffer allBuffer = new StringBuffer();
        for (i = 0; i < mapSize; ++i) {
            if (i == 0) {
                allBuffer.append(methodKeys[i]);
                continue;
            }
            allBuffer.append("," + methodKeys[i]);
        }
        allActions = allBuffer.toString();
        allSet = 0;
        for (int i2 = 0; i2 < mapSize; ++i2) {
            allSet <<= 1;
            ++allSet;
        }
        methodSetArray = new String[allSet + 1];
    }
}

