/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.groovy;

import java.util.HashSet;
import org.chromattic.groovy.ChromatticAnnotationMover;
import org.chromattic.groovy.ChromatticConstructor;
import org.chromattic.groovy.ChromatticDelegate;
import org.chromattic.groovy.ChromatticFieldChecker;
import org.chromattic.groovy.ChromatticImplementor;
import org.chromattic.groovy.GroovyUtils;
import org.chromattic.groovy.annotations.ChromatticDelegation;
import org.chromattic.groovy.exceptions.ChromatticASTTransformationException;
import org.chromattic.groovy.exceptions.NoSuchDefaultConstructor;
import org.chromattic.groovy.exceptions.NoSuchGetterException;
import org.chromattic.groovy.exceptions.NoSuchSetterException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class ChromatticASTTransformationVisitor
implements ASTTransformation {
    private final ChromatticAnnotationMover annotationMover = new ChromatticAnnotationMover();
    private final ChromatticFieldChecker fieldChecker = new ChromatticFieldChecker();
    private final ChromatticDelegate delegate = new ChromatticDelegate();
    private final ChromatticConstructor constructor = new ChromatticConstructor();
    private final ChromatticImplementor implementor = new ChromatticImplementor();

    public void visit(ASTNode[] nodes, SourceUnit sourceUnit) throws ChromatticASTTransformationException {
        for (ClassNode classNode : sourceUnit.getAST().getClasses()) {
            if (classNode.isScript() || classNode.isInterface() || !this.isInChromatticHierarchy(classNode)) continue;
            this.visitClass(classNode);
        }
    }

    private void visitClass(ClassNode classNode) throws ChromatticASTTransformationException {
        try {
            this.constructor.setProtectedDefaultConstructor(classNode);
        }
        catch (NoSuchDefaultConstructor e) {
            this.constructor.generateProtectedDefaultConstructor(classNode);
        }
        this.constructor.generatePublicHandlerConstructor(classNode);
        this.annotationMover.applyGroovyInstrumentor(classNode);
        for (FieldNode fieldNode : classNode.getFields()) {
            if (GroovyUtils.isChromatticAnnoted(fieldNode)) {
                try {
                    this.annotationMover.addSetterDelegationAnnotation(classNode, fieldNode);
                }
                catch (NoSuchSetterException e) {
                    this.annotationMover.generateSetter(classNode, fieldNode);
                }
                for (AnnotationNode annotationNode : fieldNode.getAnnotations()) {
                    if (!annotationNode.getClassNode().getName().startsWith("org.chromattic.")) continue;
                    this.fieldChecker.checkChromaticFieldType(fieldNode);
                    try {
                        this.annotationMover.addFieldAnnotationToMethod(classNode, fieldNode, annotationNode);
                    }
                    catch (NoSuchGetterException e) {
                        this.annotationMover.generateGetter(classNode, fieldNode, annotationNode);
                    }
                }
            } else if (GroovyUtils.isChromatticAnnotedInHierarchy(null, fieldNode)) {
                this.annotationMover.generateGetter(classNode, fieldNode, new AnnotationNode(new ClassNode(ChromatticDelegation.class)));
                this.annotationMover.generateSetter(classNode, fieldNode);
            }
            this.annotationMover.removeChromatticAnnotation(fieldNode);
        }
        this.delegate.setGroovyInterceptable(classNode);
        this.delegate.addInvokerField(classNode);
        try {
            this.delegate.plugGetProperty(classNode);
        }
        catch (NoSuchMethodException e) {
            this.delegate.generateGetProperty(classNode);
        }
        try {
            this.delegate.plugSetProperty(classNode);
        }
        catch (NoSuchMethodException e) {
            this.delegate.generateSetProperty(classNode);
        }
        try {
            this.delegate.plugInvokeMethod(classNode);
        }
        catch (NoSuchMethodException e) {
            this.delegate.generateInvokeMethod(classNode);
        }
        this.delegate.removeChromatticField(classNode);
        for (MethodNode methodNode : classNode.getMethods()) {
            if (!methodNode.isAbstract()) continue;
            this.implementor.implement(methodNode);
        }
    }

    private boolean isInChromatticHierarchy(ClassNode classNode) {
        if (classNode != null) {
            HashSet annotationNodeSet = new HashSet();
            annotationNodeSet.addAll(classNode.getAnnotations());
            for (FieldNode fieldNode : classNode.getFields()) {
                annotationNodeSet.addAll(fieldNode.getAnnotations());
            }
            for (MethodNode methodNode : classNode.getMethods()) {
                annotationNodeSet.addAll(methodNode.getAnnotations());
            }
            for (AnnotationNode annotationNode : annotationNodeSet) {
                if (!annotationNode.getClassNode().getName().startsWith("org.chromattic.")) continue;
                return true;
            }
            return this.isInChromatticHierarchy(classNode.getSuperClass());
        }
        return false;
    }
}

