/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link.impl;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class LinkManagerImpl
implements LinkManager {
    private static final String SYMLINK = "exo:symlink";
    private static final String WORKSPACE = "exo:workspace";
    private static final String UUID = "exo:uuid";
    private static final String PRIMARY_TYPE = "exo:primaryType";
    private static final Log LOG = ExoLogger.getLogger((String)LinkManagerImpl.class.getName());
    private final SessionProviderService providerService_;

    public LinkManagerImpl(SessionProviderService providerService) throws Exception {
        this.providerService_ = providerService;
    }

    @Override
    public Node createLink(Node parent, String linkType, Node target) throws RepositoryException {
        return this.createLink(parent, linkType, target, null);
    }

    @Override
    public Node createLink(Node parent, Node target) throws RepositoryException {
        return this.createLink(parent, null, target, null);
    }

    @Override
    public Node createLink(Node parent, String linkType, Node target, String linkName) throws RepositoryException {
        if (!target.isNodeType(SYMLINK)) {
            Node linkNode;
            block10: {
                block9: {
                    if (target.canAddMixin("mix:referenceable")) {
                        target.addMixin("mix:referenceable");
                        target.getSession().save();
                    }
                    if (linkType == null || linkType.trim().length() == 0) {
                        linkType = SYMLINK;
                    }
                    if (linkName == null || linkName.trim().length() == 0) {
                        linkName = target.getName();
                    }
                    linkNode = parent.addNode(linkName, linkType);
                    try {
                        this.updateAccessPermissionToLink(linkNode, target);
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error((Object)"CAN NOT UPDATE ACCESS PERMISSIONS FROM TARGET NODE TO LINK NODE", (Throwable)e);
                    }
                }
                linkNode.setProperty(WORKSPACE, target.getSession().getWorkspace().getName());
                linkNode.setProperty(PRIMARY_TYPE, target.getPrimaryNodeType().getName());
                linkNode.setProperty(UUID, target.getUUID());
                linkNode.getSession().save();
                ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
                try {
                    String remoteUser = WCMCoreUtils.getRemoteUser();
                    if (remoteUser != null && Utils.isDocument(target)) {
                        listenerService.broadcast("CmsService.event.postEdit", null, (Object)target);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block10;
                    LOG.error((Object)("Error while broadcasting event: " + e.getMessage()));
                }
            }
            return linkNode;
        }
        return null;
    }

    @Override
    public Node getTarget(Node link, boolean system) throws ItemNotFoundException, RepositoryException {
        String uuid = link.getProperty(UUID).getString();
        Node targetNode = this.getSession(link, system).getNodeByUUID(uuid);
        return targetNode;
    }

    private Session getSession(Node link, boolean system) throws RepositoryException {
        String workspaceTarget;
        String workspaceLink = link.getSession().getWorkspace().getName();
        if (workspaceLink.equals(workspaceTarget = link.getProperty(WORKSPACE).getString())) {
            return link.getSession();
        }
        return this.getSession((ManageableRepository)link.getSession().getRepository(), workspaceTarget, system);
    }

    private Session getSession(ManageableRepository manageRepository, String workspaceName, boolean system) throws RepositoryException {
        if (system) {
            return this.providerService_.getSystemSessionProvider(null).getSession(workspaceName, manageRepository);
        }
        return this.providerService_.getSessionProvider(null).getSession(workspaceName, manageRepository);
    }

    @Override
    public Node getTarget(Node link) throws ItemNotFoundException, RepositoryException {
        return this.getTarget(link, false);
    }

    @Override
    public boolean isTargetReachable(Node link) throws RepositoryException {
        return this.isTargetReachable(link, false);
    }

    @Override
    public boolean isTargetReachable(Node link, boolean system) throws RepositoryException {
        Session session = null;
        try {
            session = this.getSession(link, system);
            session.getNodeByUUID(link.getProperty(UUID).getString());
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public Node updateLink(Node linkNode, Node targetNode) throws RepositoryException {
        block3: {
            if (targetNode.canAddMixin("mix:referenceable")) {
                targetNode.addMixin("mix:referenceable");
                targetNode.getSession().save();
            }
            try {
                this.updateAccessPermissionToLink(linkNode, targetNode);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"CAN NOT UPDATE ACCESS PERMISSIONS FROM TARGET NODE TO LINK NODE", (Throwable)e);
            }
        }
        linkNode.setProperty(UUID, targetNode.getUUID());
        linkNode.setProperty(PRIMARY_TYPE, targetNode.getPrimaryNodeType().getName());
        linkNode.setProperty(WORKSPACE, targetNode.getSession().getWorkspace().getName());
        linkNode.getSession().save();
        return linkNode;
    }

    @Override
    public boolean isLink(Item item) throws RepositoryException {
        if (item instanceof Node) {
            Node node = (Node)item;
            if (node instanceof NodeLinkAware) {
                node = ((NodeLinkAware)node).getRealNode();
            }
            return node.isNodeType(SYMLINK);
        }
        return false;
    }

    @Override
    public String getTargetPrimaryNodeType(Node link) throws RepositoryException {
        return link.getProperty(PRIMARY_TYPE).getString();
    }

    private void updateAccessPermissionToLink(Node linkNode, Node targetNode) throws Exception {
        if (this.canChangePermission(linkNode)) {
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
                ((ExtendedNode)linkNode).setPermission(this.getNodeOwner(linkNode), PermissionType.ALL);
            }
            this.removeCurrentIdentites(linkNode);
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            List permsList = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            for (AccessControlEntry accessEntry : ((ExtendedNode)targetNode).getACL().getPermissionEntries()) {
                if (idList.contains(accessEntry.getIdentity())) continue;
                idList.add(accessEntry.getIdentity());
                permsList = ((ExtendedNode)targetNode).getACL().getPermissions(accessEntry.getIdentity());
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[permsList.size()]));
            }
            ((ExtendedNode)linkNode).setPermissions(perMap);
        }
    }

    private void removeCurrentIdentites(Node linkNode) throws AccessControlException, RepositoryException {
        String currentUser = linkNode.getSession().getUserID();
        if (currentUser != null) {
            ((ExtendedNode)linkNode).setPermission(currentUser, PermissionType.ALL);
        }
        for (AccessControlEntry accessEntry : ((ExtendedNode)linkNode).getACL().getPermissionEntries()) {
            if (!this.canRemovePermission(linkNode, accessEntry.getIdentity()) || ((ExtendedNode)linkNode).getACL().getPermissions(accessEntry.getIdentity()).size() <= 0 || accessEntry.getIdentity().equals(currentUser)) continue;
            ((ExtendedNode)linkNode).removePermission(accessEntry.getIdentity());
        }
    }

    private boolean canRemovePermission(Node node, String identity) throws ValueFormatException, PathNotFoundException, RepositoryException {
        String owner = this.getNodeOwner(node);
        if (identity.equals(IdentityConstants.SYSTEM)) {
            return false;
        }
        return owner == null || !owner.equals(identity);
    }

    private String getNodeOwner(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (node.hasProperty("exo:owner")) {
            return node.getProperty("exo:owner").getString();
        }
        return IdentityConstants.SYSTEM;
    }

    private boolean canChangePermission(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("add_node,set_property,remove");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    @Override
    public List<Node> getAllLinks(Node targetNode, String linkType, SessionProvider sessionProvider) {
        ArrayList<Node> result = new ArrayList<Node>();
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository();
            String[] workspaces = repository.getWorkspaceNames();
            String queryString = "SELECT * FROM " + linkType + " WHERE exo:uuid='" + targetNode.getUUID() + "'" + " AND exo:workspace='" + targetNode.getSession().getWorkspace().getName() + "'";
            for (String workspace : workspaces) {
                Session session = sessionProvider.getSession(workspace, repository);
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(queryString, "sql");
                QueryResult queryResult = query.execute();
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    result.add(iter.nextNode());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<Node> getAllLinks(Node targetNode, String linkType) {
        return this.getAllLinks(targetNode, linkType, WCMCoreUtils.getUserSessionProvider());
    }
}

