/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceActivityPublisher
extends SpaceListenerPlugin {
    public static final String SPACE_DISPLAY_NAME_PARAM = "SPACE_DISPLAY_NAME_PARAM";
    public static final String NUMBER_OF_PUBLIC_SPACE = "NUMBER_OF_PUBLIC_SPACE";
    public static final String USER_JOINED_PUBLIC_SPACE_TITLE_ID = "user_joined_public_space";
    public static final String USER_JOINED_PUBLIC_SPACES_TITLE_ID = "user_joined_public_spaces";
    public static final String USER_NAME_PARAM = "USER_NAME_PARAM";
    public static final String SPACE_DESCRIPTION_PARAM = "SPACE_DESCRIPTION_PARAM";
    public static final String SPACE_APP_ID = "exosocial:spaces";
    public static final String SPACE_PROFILE_ACTIVITY = "SPACE_ACTIVITY";
    public static final String USER_ACTIVITIES_FOR_SPACE = "USER_ACTIVITIES_FOR_SPACE";
    public static final String SPACE_CREATED_TITLE_ID = "space_created";
    public static final String MANAGER_GRANTED_TITLE_ID = "manager_role_granted";
    public static final String USER_JOINED_TITLE_ID = "user_joined";
    public static final String USER_SPACE_JOINED_TITLE_ID = "user_space_joined";
    public static final String MEMBER_LEFT_TITLE_ID = "member_left";
    public static final String MANAGER_REVOKED_TITLE_ID = "manager_role_revoked";
    public static final String SPACE_RENAMED_TITLE_ID = "space_renamed";
    public static final String SPACE_DESCRIPTION_EDITED_TITLE_ID = "space_description_edited";
    public static final String SPACE_AVATAR_EDITED_TITLE_ID = "space_avatar_edited";
    private static final Log LOG = ExoLogger.getExoLogger(SpaceActivityPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public SpaceActivityPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    @Override
    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = "Has joined the space.";
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        String userSpaceActivityMessage = "I joined " + space.getDisplayName() + " space";
        this.recordActivityForUserSpace(event, userSpaceActivityMessage, USER_SPACE_JOINED_TITLE_ID, templateParams, true);
        templateParams.put(SPACE_DISPLAY_NAME_PARAM, space.getDisplayName());
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        templateParams.put("registeredKeysForProcessor", USER_NAME_PARAM);
        this.recordActivity(event, "Has joined the space.", SPACE_CREATED_TITLE_ID, templateParams);
    }

    @Override
    public void spaceRemoved(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("space " + event.getSpace().getDisplayName() + " was removed!"));
    }

    @Override
    public void applicationActivated(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application <strong>" + event.getTarget() + "</strong> was activated in space " + event.getSpace().getDisplayName()));
    }

    @Override
    public void applicationAdded(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application <strong>" + event.getTarget() + "</strong> was added in space " + event.getSpace().getDisplayName()));
    }

    @Override
    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application " + event.getTarget() + " was deactivated in space " + event.getSpace().getDisplayName()));
    }

    @Override
    public void applicationRemoved(SpaceLifeCycleEvent event) {
        LOG.debug((Object)("application " + event.getTarget() + " was removed in space " + event.getSpace().getDisplayName()));
    }

    @Override
    public void grantedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = "@" + event.getTarget() + " has been promoted as space's manager.";
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        templateParams.put("registeredKeysForProcessor", USER_NAME_PARAM);
        this.recordActivity(new SpaceLifeCycleEvent(space, space.getEditor(), SpaceLifeCycleEvent.Type.GRANTED_LEAD), activityMessage, MANAGER_GRANTED_TITLE_ID, templateParams);
        LOG.debug((Object)("user " + event.getTarget() + " has been promoted as space's manager " + space.getDisplayName()));
    }

    @Override
    public void joined(SpaceLifeCycleEvent event) {
        String activityMessage = "Has joined the space.";
        String userSpaceActivityMessage = "I joined " + event.getSpace().getDisplayName() + " space";
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        this.recordActivityForUserSpace(event, userSpaceActivityMessage, USER_SPACE_JOINED_TITLE_ID, templateParams, true);
        this.recordActivity(event, "Has joined the space.", USER_JOINED_TITLE_ID, templateParams);
        LOG.debug((Object)("user " + event.getTarget() + " joined space " + event.getSpace().getDisplayName()));
    }

    @Override
    public void left(SpaceLifeCycleEvent event) {
        String activityMessage = "Has left the space.";
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        this.recordActivity(event, "Has left the space.", MEMBER_LEFT_TITLE_ID, templateParams);
        String userSpaceActivityMessage = "I left " + event.getSpace().getDisplayName() + " space";
        this.recordActivityForUserSpace(event, userSpaceActivityMessage, USER_SPACE_JOINED_TITLE_ID, templateParams, false);
        LOG.debug((Object)("user " + event.getTarget() + " has left of space " + event.getSpace().getDisplayName()));
    }

    @Override
    public void revokedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String activityMessage = "@" + event.getTarget() + " has been revoked as space's manager.";
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put(USER_NAME_PARAM, "@" + event.getTarget());
        templateParams.put("registeredKeysForProcessor", USER_NAME_PARAM);
        this.recordActivity(new SpaceLifeCycleEvent(space, space.getEditor(), SpaceLifeCycleEvent.Type.REVOKED_LEAD), activityMessage, MANAGER_REVOKED_TITLE_ID, templateParams);
        LOG.debug((Object)("user " + event.getTarget() + " has been revoked as space's manage " + event.getSpace().getDisplayName()));
    }

    @Override
    public void spaceRenamed(SpaceLifeCycleEvent event) {
        String activityMessage = "Name has been updated to: " + event.getSpace().getDisplayName();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put(SPACE_DISPLAY_NAME_PARAM, event.getSpace().getDisplayName());
        templateParams.put("registeredKeysForProcessor", SPACE_DISPLAY_NAME_PARAM);
        this.recordActivity(event, activityMessage, SPACE_RENAMED_TITLE_ID, templateParams);
        LOG.debug((Object)"Name has been updated ");
        if (Space.UpdatedField.DESCRIPTION.equals((Object)event.getSpace().getField())) {
            this.spaceDescriptionEdited(event);
        }
    }

    @Override
    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        String activityMessage = "Description has been updated to: " + event.getSpace().getDescription();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put(SPACE_DESCRIPTION_PARAM, event.getSpace().getDescription());
        templateParams.put("registeredKeysForProcessor", SPACE_DESCRIPTION_PARAM);
        this.recordActivity(event, activityMessage, SPACE_DESCRIPTION_EDITED_TITLE_ID, templateParams);
        LOG.debug((Object)"Description has been updated ");
    }

    @Override
    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        String activityMessage = "Space has a new avatar.";
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        this.recordActivity(event, "Space has a new avatar.", SPACE_AVATAR_EDITED_TITLE_ID, templateParams);
        LOG.debug((Object)"Space has a new avatar.");
    }

    @Override
    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        String[] members;
        ExoSocialActivityImpl activity;
        Space space = event.getSpace();
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        String spaceActivityId = this.getStorage().getProfileActivityId(spaceIdentity.getProfile(), Profile.AttachedActivityType.SPACE);
        if (spaceActivityId != null && (activity = (ExoSocialActivityImpl)this.activityManager.getActivity(spaceActivityId)) != null) {
            if ("hidden".equals(space.getVisibility())) {
                activity.isHidden(true);
            }
            if ("private".equals(space.getVisibility())) {
                activity.isHidden(false);
            }
            this.activityManager.updateActivity(activity);
        }
        for (String member : members = space.getMembers()) {
            ExoSocialActivityImpl activity2;
            Identity identity = this.identityManager.getOrCreateIdentity("organization", member, false);
            String userSpaceActivityId = this.getStorage().getProfileActivityId(identity.getProfile(), Profile.AttachedActivityType.RELATION);
            if (userSpaceActivityId == null || (activity2 = (ExoSocialActivityImpl)this.activityManager.getActivity(userSpaceActivityId)) == null) continue;
            int numberOfSpacesOfMember = this.getSpaceStorage().getNumberOfMemberPublicSpaces(identity.getRemoteId());
            Map templateParams = activity2.getTemplateParams();
            templateParams.put(NUMBER_OF_PUBLIC_SPACE, String.valueOf(numberOfSpacesOfMember));
            templateParams.put("registeredKeysForProcessor", NUMBER_OF_PUBLIC_SPACE);
            activity2.setTemplateParams(templateParams);
            if (numberOfSpacesOfMember > 1) {
                activity2.setTitle("I now member of " + numberOfSpacesOfMember + " spaces");
                activity2.setTitleId(USER_JOINED_PUBLIC_SPACES_TITLE_ID);
            } else {
                activity2.setTitle("I now member of " + numberOfSpacesOfMember + " space");
                activity2.setTitleId(USER_JOINED_PUBLIC_SPACE_TITLE_ID);
            }
            this.activityManager.updateActivity(activity2);
        }
    }

    private void recordActivity(SpaceLifeCycleEvent event, String activityMessage, String titleId, Map<String, String> templateParams) {
        Space space = event.getSpace();
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        Identity identity = this.identityManager.getOrCreateIdentity("organization", event.getTarget(), false);
        String activityId = this.getStorage().getProfileActivityId(spaceIdentity.getProfile(), Profile.AttachedActivityType.SPACE);
        if (activityId != null) {
            try {
                if (!"Has left the space.".equals(activityMessage)) {
                    ExoSocialActivity comment = this.createComment(activityMessage, titleId, null, SPACE_APP_ID, identity, templateParams);
                    ExoSocialActivityImpl activity = (ExoSocialActivityImpl)this.activityManager.getActivity(activityId);
                    this.activityManager.saveComment(activity, comment);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Run in case of activity deleted and reupdate");
                activityId = null;
            }
        }
        if (activityId == null) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setType(SPACE_PROFILE_ACTIVITY);
            activity.setTitle(space.getDisplayName() + " was created by @" + event.getTarget() + " .");
            if ("hidden".equals(space.getVisibility())) {
                activity.isHidden(true);
            }
            this.activityManager.saveActivityNoReturn(spaceIdentity, activity);
            this.getStorage().updateProfileActivityId(spaceIdentity, activity.getId(), Profile.AttachedActivityType.SPACE);
            if (SPACE_CREATED_TITLE_ID.equals(titleId)) {
                titleId = USER_JOINED_TITLE_ID;
            }
            ExoSocialActivity comment = this.createComment(activityMessage, titleId, null, SPACE_APP_ID, identity, templateParams);
            this.activityManager.saveComment(activity, comment);
        }
    }

    private void recordActivityForUserSpace(SpaceLifeCycleEvent event, String userSpaceActivityMessage, String titleId, Map<String, String> templateParams, boolean isJoined) {
        ExoSocialActivity comment;
        Space space = event.getSpace();
        if (space.getVisibility().equals("hidden")) {
            return;
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", event.getTarget(), false);
        String activityId = this.getStorage().getProfileActivityId(identity.getProfile(), Profile.AttachedActivityType.RELATION);
        int numberOfSpacesOfMember = this.getSpaceStorage().getNumberOfMemberPublicSpaces(identity.getRemoteId());
        ExoSocialActivityImpl activity = null;
        if (activityId != null) {
            activity = (ExoSocialActivityImpl)this.activityManager.getActivity(activityId);
        }
        if (activity == null) {
            activity = new ExoSocialActivityImpl();
            activity.setType(USER_ACTIVITIES_FOR_SPACE);
        }
        templateParams.put(NUMBER_OF_PUBLIC_SPACE, String.valueOf(numberOfSpacesOfMember));
        templateParams.put("registeredKeysForProcessor", NUMBER_OF_PUBLIC_SPACE);
        activity.setTemplateParams(templateParams);
        if (numberOfSpacesOfMember > 1) {
            activity.setTitle("I now member of " + numberOfSpacesOfMember + " spaces");
            activity.setTitleId(USER_JOINED_PUBLIC_SPACES_TITLE_ID);
        } else {
            activity.setTitle("I now member of " + numberOfSpacesOfMember + " space");
            activity.setTitleId(USER_JOINED_PUBLIC_SPACE_TITLE_ID);
        }
        if (activityId != null) {
            if (isJoined) {
                try {
                    comment = this.createComment(userSpaceActivityMessage, titleId, event.getSpace().getDisplayName(), USER_ACTIVITIES_FOR_SPACE, identity, new LinkedHashMap<String, String>());
                    this.activityManager.updateActivity(activity);
                    this.activityManager.saveComment(activity, comment);
                }
                catch (Exception e) {
                    LOG.debug((Object)"Run in case of activity deleted");
                    activityId = null;
                }
            } else {
                this.activityManager.updateActivity(activity);
            }
        }
        if (activityId == null) {
            this.activityManager.saveActivityNoReturn(identity, activity);
            this.getStorage().updateProfileActivityId(identity, activity.getId(), Profile.AttachedActivityType.RELATION);
            activity = (ExoSocialActivityImpl)this.activityManager.getActivity(activity.getId());
            comment = this.createComment(userSpaceActivityMessage, titleId, event.getSpace().getDisplayName(), USER_ACTIVITIES_FOR_SPACE, identity, new LinkedHashMap<String, String>());
            this.activityManager.saveComment(activity, comment);
        }
    }

    private ExoSocialActivity createComment(String title, String titleId, String spacePrettyName, String type, Identity identity, Map<String, String> templateParams) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(title);
        comment.setTitleId(titleId);
        comment.setUserId(identity.getId());
        comment.setType(type);
        if (spacePrettyName != null) {
            templateParams.put(SPACE_DISPLAY_NAME_PARAM, spacePrettyName);
            templateParams.put("registeredKeysForProcessor", SPACE_DISPLAY_NAME_PARAM);
        }
        comment.setTemplateParams(templateParams);
        return comment;
    }

    private IdentityStorage getStorage() {
        return (IdentityStorage)PortalContainer.getInstance().getComponentInstanceOfType(IdentityStorage.class);
    }

    private SpaceStorage getSpaceStorage() {
        return (SpaceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SpaceStorage.class);
    }
}

