/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.IOException;
import java.util.Properties;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableTreeFileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFileValueStorage;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class CASableTreeFileValueStorage
extends TreeFileValueStorage {
    private ValueContentAddressStorage vcas;
    private String digestAlgo;

    public CASableTreeFileValueStorage(FileCleaner fileCleaner) {
        super(fileCleaner);
    }

    public void init(Properties props, ValueDataResourceHolder resources) throws IOException, RepositoryConfigurationException {
        super.init(props, resources);
        this.digestAlgo = props.getProperty("digest-algo");
        String vcasType = props.getProperty("vcas-type");
        try {
            this.vcas = (ValueContentAddressStorage)ClassLoading.forName((String)vcasType, (Object)this).newInstance();
        }
        catch (ExceptionInInitializerError e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        catch (SecurityException e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        catch (InstantiationException e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryConfigurationException("VCAS Storage class load error " + e, e);
        }
        this.vcas.init(props);
    }

    public FileIOChannel openIOChannel() throws IOException {
        return new CASableTreeFileIOChannel(this.rootDir, this.cleaner, this.getId(), this.resources, this.vcas, this.digestAlgo);
    }
}

