/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade.domain;

import java.net.URL;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;

public class RemoveDomainInUrlUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(RemoveDomainInUrlUpgradePlugin.class);

    public RemoveDomainInUrlUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"\n\nStart check url wiki page...\n");
        try {
            this.removeDomainNameInURL();
        }
        catch (Exception e) {
            LOG.warn((Object)"[WikiRemoveDomainNameInURLPlugin] Exception when fix null url for wiki page:", (Throwable)e);
        }
        LOG.info((Object)"\n\nFinish ...\n");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    public void removeDomainNameInURL() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        ChromatticSession session = mowService.getSession();
        QueryResult pageIterator = session.createQueryBuilder(PageImpl.class).where("jcr:path LIKE '/%'").get().objects();
        LOG.info("\nTotal pages found: {}\n", new Object[]{pageIterator.size()});
        int checkedPage = 0;
        while (pageIterator.hasNext()) {
            PageImpl page = (PageImpl)pageIterator.next();
            try {
                String oldPageURL = page.getURL();
                LOG.info("\nOld wiki Page URL:", new Object[]{oldPageURL});
                if (oldPageURL != null) {
                    URL oldURL = new URL(oldPageURL);
                    String newURL = oldURL.getPath();
                    page.setURL(newURL);
                    LOG.info("\nNew URL:", new Object[]{newURL});
                }
                LOG.info("\nFixed page: {}/{}\n", new Object[]{++checkedPage, pageIterator.size()});
            }
            catch (Exception e) {
                LOG.warn((Object)String.format("cannot repair the hostname for page's url %s", page.getName()), (Throwable)e);
            }
        }
        RequestLifeCycle.end();
    }
}

