/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class NewGroupListener
extends GroupEventListener {
    private static final Log log = ExoLogger.getLogger(NewGroupListener.class);
    protected CalendarService calendarService_;
    private String defaultCalendarDescription;
    private String defaultLocale;
    private String defaultTimeZone;
    private String[] editPermission;
    private String[] viewPermission;
    private List<String> ignore_groups_;
    public final String ST_GROUP_IGNORE = "ignoredGroups".intern();

    public NewGroupListener(CalendarService calendarService, InitParams params) {
        this.calendarService_ = calendarService;
        if (params.getValueParam("defaultEditPermission") != null) {
            this.editPermission = params.getValueParam("defaultEditPermission").getValue().split(",");
        }
        if (params.getValueParam("defaultViewPermission") != null) {
            this.viewPermission = params.getValueParam("defaultViewPermission").getValue().split(",");
        }
        if (params.getValueParam("defaultCalendarDescription") != null) {
            this.defaultCalendarDescription = params.getValueParam("defaultCalendarDescription").getValue();
        }
        if (params.getValueParam("defaultLocale") != null) {
            this.defaultLocale = params.getValueParam("defaultLocale").getValue();
        }
        if (params.getValueParam("defaultTimeZone") != null) {
            this.defaultTimeZone = params.getValueParam("defaultTimeZone").getValue();
        }
        if (params.getValuesParam(this.ST_GROUP_IGNORE) != null && !params.getValuesParam(this.ST_GROUP_IGNORE).getValues().isEmpty()) {
            this.ignore_groups_ = params.getValuesParam(this.ST_GROUP_IGNORE).getValues();
        }
    }

    public void postSave(Group group, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        String groupId = group.getId();
        String parentId = group.getParentId();
        if (this.ignore_groups_ != null && !this.ignore_groups_.isEmpty()) {
            for (String g : this.ignore_groups_) {
                if (groupId.equalsIgnoreCase(g)) {
                    return;
                }
                if (g.lastIndexOf("/*") <= -1 || !g.substring(0, g.lastIndexOf("/*")).equalsIgnoreCase(parentId)) continue;
                return;
            }
        }
        boolean isPublic = true;
        Calendar calendar = new Calendar();
        String calName = group.getLabel();
        if (calName == null || "".equals(calName)) {
            calName = group.getGroupName();
        }
        calendar.setName(calName);
        if (this.defaultCalendarDescription != null) {
            calendar.setDescription(this.defaultCalendarDescription);
        }
        calendar.setGroups(new String[]{groupId});
        calendar.setPublic(isPublic);
        if (this.defaultLocale != null) {
            calendar.setLocale(this.defaultLocale);
        }
        if (this.defaultTimeZone != null) {
            calendar.setTimeZone(this.defaultTimeZone);
        }
        calendar.setCalendarColor(Calendar.COLORS[0]);
        ArrayList<String> perms = new ArrayList<String>();
        if (this.viewPermission != null) {
            for (String s : this.viewPermission) {
                if (perms.contains(s)) continue;
                perms.add(s);
            }
        }
        calendar.setViewPermission(perms.toArray(new String[perms.size()]));
        perms.clear();
        if (this.editPermission != null) {
            for (String s : this.editPermission) {
                String groupKey = groupId + "/:" + s;
                if (perms.contains(groupKey)) continue;
                perms.add(groupKey);
            }
        }
        calendar.setEditPermission(perms.toArray(new String[perms.size()]));
        this.calendarService_.savePublicCalendar(calendar, isNew);
    }

    public void postDelete(Group group) throws Exception {
        block4: {
            try {
                List<GroupCalendarData> gCalData = this.calendarService_.getGroupCalendars(new String[]{group.getId()}, true, null);
                for (GroupCalendarData gc : gCalData) {
                    if (gc == null || gc.getCalendars().isEmpty()) continue;
                    for (Calendar c : gc.getCalendars()) {
                        this.calendarService_.removePublicCalendar(c.getId());
                    }
                }
                super.postDelete(group);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)String.format("Can not clear calendars of [%s]", group != null ? group.getGroupName() : "null"), (Throwable)e);
            }
        }
    }
}

