/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.plugin.doc.UIDocActivitySelector;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/social/plugin/doc/UIDocActivityComposer.gtmpl", events={@EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class}), @EventConfig(listeners={SelectDocumentActionListener.class}), @EventConfig(listeners={RemoveDocumentActionListener.class})})
public class UIDocActivityComposer
extends UIActivityComposer
implements UISelectable {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivityComposer.class);
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "collaboration";
    private final String POPUP_COMPOSER = "UIPopupComposer";
    private final String docActivityTitle = "Shared a document <a href=\"${DOCLINK}\">${DOCNAME}</a>";
    private String documentRefLink;
    private String documentPath;
    private String documentName;
    private boolean isDocumentReady;
    private String currentUser;

    public UIDocActivityComposer() {
        this.addChild((UIComponent)new UIFormStringInput("InputDoc", "InputDoc", null));
        this.resetValues();
    }

    private void resetValues() {
        this.documentRefLink = "";
        this.isDocumentReady = false;
        this.setReadyForPostingActivity(false);
    }

    public boolean isDocumentReady() {
        return this.isDocumentReady;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    protected void onActivate(Event<UIActivityComposer> event) {
        this.isDocumentReady = false;
        this.setCurrentUser(event.getRequestContext().getRemoteUser());
    }

    private UIPopupWindow showDocumentPopup(UIDocActivityComposer docActivityComposer) {
        UIComponent child;
        UIComposer uiComposer = (UIComposer)docActivityComposer.getAncestorOfType(UIComposer.class);
        UIContainer optionContainer = uiComposer.getOptionContainer();
        UIPopupWindow uiPopup = (UIPopupWindow)optionContainer.getChild(UIPopupWindow.class);
        if (uiPopup == null) {
            try {
                uiPopup = (UIPopupWindow)optionContainer.addChild(UIPopupWindow.class, null, "UIPopupComposer");
            }
            catch (Exception e) {
                LOG.error((Object)"An exception happens when add document popup.\n Cause by: ", (Throwable)e);
                return null;
            }
        }
        if ((child = uiPopup.getUIComponent()) != null && child instanceof UIDocActivitySelector) {
            uiPopup.setShow(true);
            uiPopup.setResizable(true);
        } else {
            try {
                UIDocActivitySelector selector = (UIDocActivitySelector)uiPopup.createUIComponent(UIDocActivitySelector.class, null, null);
                uiPopup.setUIComponent((UIComponent)selector);
                uiPopup.setShow(true);
                uiPopup.setResizable(true);
            }
            catch (Exception e) {
                LOG.error((Object)"An exception happens when add document popup.\n Cause by: ", (Throwable)e);
            }
        }
        uiPopup.setWindowSize(500, 0);
        return uiPopup;
    }

    protected void onClose(Event<UIActivityComposer> event) {
        this.resetValues();
    }

    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
        if (!this.isDocumentReady) {
            requestContext.getUIApplication().addMessage(new ApplicationMessage("UIComposer.msg.error.Must_select_file", null, 2));
        } else {
            LinkedHashMap<String, String> activityParams = new LinkedHashMap<String, String>();
            activityParams.put("DOCNAME", this.documentName);
            activityParams.put("DOCLINK", this.documentRefLink);
            activityParams.put("DOCPATH", this.documentPath);
            activityParams.put("REPOSITORY", REPOSITORY);
            activityParams.put("WORKSPACE", WORKSPACE);
            activityParams.put("MESSAGE", postedMessage);
            activityParams.put("registeredKeysForProcessor", "MESSAGE");
            if (postContext == UIComposer.PostContext.SPACE) {
                this.postActivityToSpace(source, requestContext, activityParams);
            } else if (postContext == UIComposer.PostContext.USER) {
                this.postActivityToUser(source, requestContext, activityParams);
            }
        }
        this.resetValues();
    }

    private void postActivityToUser(UIComponent source, WebuiRequestContext requestContext, Map<String, String> activityParams) throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
        UIComposer uiComposer = (UIComposer)source;
        ActivityManager activityManager = (ActivityManager)uiComposer.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)uiComposer.getApplicationComponent(IdentityManager.class);
        String ownerName = uiUserActivitiesDisplay.getOwnerName();
        Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName, true);
        String remoteUser = requestContext.getRemoteUser();
        this.saveActivity(activityParams, activityManager, identityManager, ownerIdentity, remoteUser);
    }

    private void postActivityToSpace(UIComponent source, WebuiRequestContext requestContext, Map<String, String> activityParams) throws Exception {
        UIComposer uiComposer = (UIComposer)source;
        ActivityManager activityManager = (ActivityManager)uiComposer.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)uiComposer.getApplicationComponent(IdentityManager.class);
        SpaceService spaceSrv = (SpaceService)uiComposer.getApplicationComponent(SpaceService.class);
        Space space = spaceSrv.getSpaceByUrl(SpaceUtils.getSpaceUrl());
        Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getName(), false);
        String remoteUser = requestContext.getRemoteUser();
        ExoSocialActivity activity = this.saveActivity(activityParams, activityManager, identityManager, spaceIdentity, remoteUser);
        UISpaceActivitiesDisplay uiDisplaySpaceActivities = (UISpaceActivitiesDisplay)this.getActivityDisplay();
        UIActivitiesContainer activitiesContainer = uiDisplaySpaceActivities.getActivitiesLoader().getActivitiesContainer();
        activitiesContainer.addActivity(activity);
        requestContext.addUIComponentToUpdateByAjax((UIComponent)activitiesContainer);
        requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposer);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String rawPath = value.toString();
        rawPath = rawPath.substring(rawPath.indexOf(":/") + 2);
        this.documentRefLink = this.buildDocumentLink(rawPath);
        this.documentName = rawPath.substring(rawPath.lastIndexOf("/") + 1);
        this.documentPath = this.buildDocumentPath(rawPath);
        this.isDocumentReady = true;
        System.out.println("path : " + this.documentPath);
        this.documentRefLink = this.documentRefLink.replace("//", "/");
        this.documentPath = this.documentPath.replace("//", "/");
        this.setReadyForPostingActivity(true);
    }

    private ExoSocialActivity saveActivity(Map<String, String> activityParams, ActivityManager activityManager, IdentityManager identityManager, Identity ownerIdentity, String remoteUser) throws ActivityStorageException {
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "DOC_ACTIVITY", "Shared a document <a href=\"${DOCLINK}\">${DOCNAME}</a>", null);
        activity.setTemplateParams(activityParams);
        activityManager.saveActivity(ownerIdentity, (ExoSocialActivity)activity);
        return activity;
    }

    private String buildDocumentLink(String rawPath) {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        String restService = "jcr";
        return "/" + portalContainerName + "/" + restContextName + "/" + restService + "/" + REPOSITORY + "/" + WORKSPACE + "/" + rawPath;
    }

    public String buildDocumentPath(String rawPath) {
        return "/" + rawPath;
    }

    public static class RemoveDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            docActivityComposer.resetValues();
        }
    }

    public static class SelectDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            UIPopupWindow uiPopup = docActivityComposer.showDocumentPopup(docActivityComposer);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
        }
    }
}

