/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget;

import java.io.IOException;
import java.net.URL;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.exoplatform.application.gadget.GadgetImporter;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.RemoteGadgetData;
import org.gatein.common.net.URLTools;

public class RemoteImporter
extends GadgetImporter {
    public RemoteImporter(String name, String gadgetPath) {
        super(name, gadgetPath);
    }

    @Override
    protected byte[] getGadgetBytes(String gadgetURI) throws IOException {
        URL url = new URL(gadgetURI);
        return URLTools.getContent((URL)url, (int)5000, (int)5000);
    }

    @Override
    protected String getGadgetURL() {
        return this.getGadgetURI();
    }

    @Override
    protected void process(String gadgetURI, GadgetDefinition def) throws Exception {
        def.setLocal(false);
        RemoteGadgetData data = (RemoteGadgetData)def.getData();
        data.setURL(gadgetURI);
    }

    @Override
    protected void processMetadata(ModulePrefs prefs, GadgetDefinition def) {
        String gadgetName = def.getName();
        String description = prefs.getDescription();
        String thumbnail = prefs.getThumbnail().toString();
        String title = this.getGadgetTitle(prefs, gadgetName);
        String referenceURL = prefs.getTitleUrl().toString();
        log.info((Object)("Importing gadget name=" + gadgetName + " description=" + description + " thumbnail=" + thumbnail + " title=" + thumbnail + " title=" + title));
        def.setDescription(description);
        def.setThumbnail(thumbnail);
        def.setTitle(title);
        def.setReferenceURL(referenceURL);
    }

    private String getGadgetTitle(ModulePrefs prefs, String defaultValue) {
        String title = prefs.getDirectoryTitle();
        if (title == null || title.trim().length() < 1) {
            title = prefs.getTitle();
        }
        if (title == null || title.trim().length() < 1) {
            return defaultValue;
        }
        return title;
    }
}

