/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.core;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.selector.UIGroupMemberSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

public abstract class UIPermissionFormBase
extends UIForm
implements UISelectable {
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "SelectUserOrGroup";
    public static final String SYMLINK = "exo:symlink";
    private static final String[] PERMISSION_TYPES = new String[]{"read", "add_node", "remove"};
    protected static final Log LOG = ExoLogger.getLogger((String)UIPermissionFormBase.class.getName());

    public UIPermissionFormBase() throws Exception {
        this.addChild((UIComponent)new UIPermissionInputSet(PERMISSION));
        this.setActions(new String[]{"Save", "Reset", "Close"});
    }

    public abstract Node getCurrentNode() throws Exception;

    public void fillForm(String user, ExtendedNode node) throws Exception {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        this.refresh();
        uiInputSet.getUIStringInput("userOrGroup").setValue((Object)user);
        if (user.equals(Utils.getNodeOwner((Node)node))) {
            for (String perm : PERMISSION_TYPES) {
                uiInputSet.getUICheckBoxInput(perm).setChecked(true);
            }
        } else {
            List permsList = node.getACL().getPermissionEntries();
            Iterator perIter = permsList.iterator();
            StringBuilder userPermission = new StringBuilder();
            while (perIter.hasNext()) {
                AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                if (!user.equals(accessControlEntry.getIdentity())) continue;
                userPermission.append(accessControlEntry.getPermission()).append(" ");
            }
            for (String perm : PERMISSION_TYPES) {
                boolean isCheck = userPermission.toString().contains(perm);
                uiInputSet.getUICheckBoxInput(perm).setChecked(isCheck);
            }
        }
    }

    public void updateSymlinks(Node node) throws Exception {
        if (node.isNodeType("mix:referenceable")) {
            LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            List symlinks = linkManager.getAllLinks(node, SYMLINK);
            for (Node symlink : symlinks) {
                try {
                    linkManager.updateLink(symlink, node);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
    }

    protected void lockForm(boolean isLock) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        if (isLock) {
            uiInputSet.setButtonActions(new String[]{"Reset"});
        } else {
            uiInputSet.setButtonActions(new String[]{"Save", "Reset"});
        }
        for (String perm : PERMISSION_TYPES) {
            uiInputSet.getUICheckBoxInput(perm).setDisabled(isLock);
        }
    }

    protected boolean isEditable(Node node) throws Exception {
        return PermissionUtil.canChangePermission(node);
    }

    protected void refresh() {
        this.reset();
        this.checkAll(false);
    }

    protected void checkAll(boolean check) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        for (String perm : PERMISSION_TYPES) {
            uiInputSet.getUICheckBoxInput(perm).setChecked(check);
        }
    }

    protected String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner(node);
    }

    public static class SelectMemberActionListener
    extends EventListener<UIPermissionFormBase> {
        public void execute(Event<UIPermissionFormBase> event) throws Exception {
            UIPermissionFormBase uiForm = (UIPermissionFormBase)event.getSource();
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiForm.createUIComponent(UIGroupMemberSelector.class, null, null);
            uiGroupMemberSelector.setSourceComponent((UIComponent)uiForm, new String[]{"userOrGroup"});
            ((UIPermissionManagerBase)uiForm.getAncestorOfType(UIPermissionManagerBase.class)).initPopupPermission((UIComponent)uiGroupMemberSelector);
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class AddAnyActionListener
    extends EventListener<UIPermissionFormBase> {
        public void execute(Event<UIPermissionFormBase> event) throws Exception {
            UIPermissionFormBase uiForm = (UIPermissionFormBase)event.getSource();
            UIPermissionInputSet uiInputSet = (UIPermissionInputSet)uiForm.getChildById(UIPermissionFormBase.PERMISSION);
            uiInputSet.getUIStringInput("userOrGroup").setValue((Object)IdentityConstants.ANY);
            uiForm.checkAll(false);
            uiInputSet.getUICheckBoxInput("read").setChecked(true);
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class SelectUserActionListener
    extends EventListener<UIPermissionFormBase> {
        public void execute(Event<UIPermissionFormBase> event) throws Exception {
            UIPermissionFormBase uiForm = (UIPermissionFormBase)event.getSource();
            ((UIPermissionManagerBase)uiForm.getParent()).initUserSelector();
            UIPopupContainer popupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
            if (popupContainer != null) {
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
            }
        }
    }

    public static class ResetActionListener
    extends EventListener<UIPermissionFormBase> {
        public void execute(Event<UIPermissionFormBase> event) throws Exception {
            UIPermissionFormBase uiForm = (UIPermissionFormBase)event.getSource();
            uiForm.lockForm(false);
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

