/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.DuplicateNameException;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.ext.ntdef.NTFolder;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.chromattic.ext.ntdef.VersionableMixin;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.GroupWiki;
import org.exoplatform.wiki.mow.core.api.wiki.MovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.PermissionImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWiki;
import org.exoplatform.wiki.mow.core.api.wiki.RemovedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.RenamedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.Trash;
import org.exoplatform.wiki.mow.core.api.wiki.UserWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WatchedMixin;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.exoplatform.wiki.rendering.converter.ConfluenceToXWiki2Transformer;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiService;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.syntax.Syntax;

@PrimaryType(name="wiki:page")
public abstract class PageImpl
extends NTFolder
implements Page {
    private MOWService mowService;
    private WikiService wService;
    private Permission permission = new PermissionImpl();
    private ComponentManager componentManager;
    private List<PageImpl> relatedPages = null;
    private boolean isMinorEdit = false;

    public void setMOWService(MOWService mowService) {
        this.mowService = mowService;
        this.permission.setMOWService(mowService);
    }

    public MOWService getMOWService() {
        return this.mowService;
    }

    public void setWikiService(WikiService wService) {
        this.wService = wService;
    }

    public ChromatticSession getChromatticSession() {
        return this.mowService.getSession();
    }

    public Session getJCRSession() {
        return this.getChromatticSession().getJCRSession();
    }

    public WikiService getWikiService() {
        return this.wService;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    public Node getJCRPageNode() throws Exception {
        return (Node)this.getChromatticSession().getJCRSession().getItem(this.getPath());
    }

    @Override
    @Name
    public abstract String getName();

    @Override
    public abstract void setName(String var1);

    @Path
    public abstract String getPath();

    @WorkspaceName
    public abstract String getWorkspace();

    @OneToOne
    @Owner
    @MappedBy(value="content")
    protected abstract AttachmentImpl getContentByChromattic();

    protected abstract void setContentByChromattic(AttachmentImpl var1);

    @Create
    protected abstract AttachmentImpl createContent();

    @Override
    public AttachmentImpl getContent() {
        AttachmentImpl content = this.getContentByChromattic();
        if (content == null) {
            content = this.createContent();
            this.setContentByChromattic(content);
        } else {
            String syntax = this.getSyntax();
            if (Syntax.CONFLUENCE_1_0.toIdString().equals(syntax)) {
                content.setText(ConfluenceToXWiki2Transformer.transformContent((String)content.getText(), (ComponentManager)this.componentManager));
                this.setSyntax(Syntax.XWIKI_2_0.toIdString());
                this.setContentByChromattic(content);
            }
        }
        return content;
    }

    @Property(name="title")
    public abstract String getTitleByChromattic();

    public abstract void setTitleByChromattic(String var1);

    @Override
    public String getTitle() {
        String title = this.getTitleByChromattic();
        return title != null ? title : this.getName();
    }

    @Override
    public void setTitle(String title) {
        this.setTitleByChromattic(title);
    }

    @Override
    @Property(name="syntax")
    public abstract String getSyntax();

    @Override
    public abstract void setSyntax(String var1);

    @Override
    @Property(name="comment")
    @DefaultValue(value={""})
    public abstract String getComment();

    @Override
    public abstract void setComment(String var1);

    @Override
    @Property(name="owner")
    public abstract String getOwner();

    public abstract void setOwner(String var1);

    @Override
    @Property(name="author")
    public abstract String getAuthor();

    @Override
    @Property(name="createdDate")
    public abstract Date getCreatedDate();

    public abstract void setCreatedDate(Date var1);

    @Override
    @Property(name="updatedDate")
    public abstract Date getUpdatedDate();

    @Override
    @Property(name="url")
    public abstract String getURL();

    @Override
    public abstract void setURL(String var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract MovedMixin getMovedMixin();

    public abstract void setMovedMixin(MovedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract RemovedMixin getRemovedMixin();

    public abstract void setRemovedMixin(RemovedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract RenamedMixin getRenamedMixin();

    public abstract void setRenamedMixin(RenamedMixin var1);

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract WatchedMixin getWatchedMixin();

    public abstract void setWatchedMixin(WatchedMixin var1);

    @Create
    protected abstract WatchedMixin createWatchedMixin();

    public void makeWatched() {
        WatchedMixin watchedMixin = this.getWatchedMixin();
        if (watchedMixin == null) {
            watchedMixin = this.createWatchedMixin();
            this.setWatchedMixin(watchedMixin);
        }
    }

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract VersionableMixin getVersionableMixinByChromattic();

    protected abstract void setVersionableMixinByChromattic(VersionableMixin var1);

    @Create
    protected abstract VersionableMixin createVersionableMixin();

    @Override
    public VersionableMixin getVersionableMixin() {
        VersionableMixin versionableMixin = this.getVersionableMixinByChromattic();
        if (versionableMixin == null) {
            versionableMixin = this.createVersionableMixin();
            this.setVersionableMixinByChromattic(versionableMixin);
        }
        return versionableMixin;
    }

    public void makeVersionable() {
        this.getVersionableMixin();
    }

    public NTVersion checkin() throws Exception {
        this.getChromatticSession().save();
        Node pageNode = this.getJCRPageNode();
        Version newVersion = pageNode.checkin();
        NTVersion ntVersion = (NTVersion)this.getChromatticSession().findByNode(NTVersion.class, (Node)newVersion);
        return ntVersion;
    }

    public void checkout() throws Exception {
        Node pageNode = this.getJCRPageNode();
        pageNode.checkout();
    }

    public void restore(String versionName, boolean removeExisting) throws Exception {
        Node pageNode = this.getJCRPageNode();
        pageNode.restore(versionName, removeExisting);
    }

    @Create
    public abstract AttachmentImpl createAttachment();

    public AttachmentImpl createAttachment(String fileName, Resource contentResource) throws Exception {
        if (fileName == null) {
            throw new NullPointerException();
        }
        for (AttachmentImpl att : this.getAttachments()) {
            if (!att.getName().equals(fileName)) continue;
            att.remove();
        }
        AttachmentImpl file = this.createAttachment();
        file.setName(TitleResolver.getId(fileName, false));
        this.addAttachment(file);
        if (fileName.lastIndexOf(".") > 0) {
            file.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
            file.setFileType(fileName.substring(fileName.lastIndexOf(".")));
        } else {
            file.setTitle(fileName);
        }
        if (contentResource != null) {
            file.setContentResource(contentResource);
        }
        this.getChromatticSession().save();
        this.setFullPermissionForOwner(file);
        return file;
    }

    private void setFullPermissionForOwner(AttachmentImpl file) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            HashMap<String, String[]> permissions = file.getPermission();
            permissions.put(conversationState.getIdentity().getUserId(), org.exoplatform.services.jcr.access.PermissionType.ALL);
            file.setPermission(permissions);
        }
    }

    @OneToMany
    public abstract Collection<AttachmentImpl> getAttachmentsByChromattic();

    public Collection<AttachmentImpl> getAttachments() {
        return this.getAttachmentsByChromattic();
    }

    public Collection<AttachmentImpl> getAttachmentsExcludeContent() throws Exception {
        Collection<AttachmentImpl> attachments = this.getAttachmentsByChromattic();
        ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>(attachments.size());
        for (AttachmentImpl attachment : attachments) {
            if (!attachment.hasPermission(PermissionType.VIEW_ATTACHMENT) && !attachment.hasPermission(PermissionType.EDIT_ATTACHMENT) || "content".equals(attachment.getName())) continue;
            atts.add(attachment);
        }
        Collections.sort(atts);
        return atts;
    }

    public Collection<AttachmentImpl> getAttachmentsExcludeContentByRootPermisison() throws Exception {
        Collection<AttachmentImpl> attachments = this.getAttachmentsByChromattic();
        ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>(attachments.size());
        for (AttachmentImpl attachment : attachments) {
            if ("content".equals(attachment.getName())) continue;
            atts.add(attachment);
        }
        Collections.sort(atts);
        return atts;
    }

    public AttachmentImpl getAttachment(String attachmentId) throws Exception {
        for (AttachmentImpl attachment : this.getAttachments()) {
            if (!attachment.getName().equals(attachmentId) || !attachment.hasPermission(PermissionType.VIEW_ATTACHMENT) && !attachment.hasPermission(PermissionType.EDIT_ATTACHMENT)) continue;
            return attachment;
        }
        return null;
    }

    public AttachmentImpl getAttachmentByRootPermisison(String attachmentId) throws Exception {
        for (AttachmentImpl attachment : this.getAttachments()) {
            if (!attachment.getName().equals(attachmentId)) continue;
            return attachment;
        }
        return null;
    }

    public void addAttachment(AttachmentImpl attachment) throws DuplicateNameException {
        this.getAttachments().add(attachment);
    }

    public void removeAttachment(String attachmentId) throws Exception {
        AttachmentImpl attachment = this.getAttachment(attachmentId);
        if (attachment != null) {
            attachment.remove();
        }
    }

    @Override
    @ManyToOne
    public abstract PageImpl getParentPage();

    public abstract void setParentPage(PageImpl var1);

    @ManyToOne
    public abstract Trash getTrash();

    public abstract void setTrash(Trash var1);

    @OneToMany
    protected abstract Map<String, PageImpl> getChildrenContainer();

    public Map<String, PageImpl> getChildPages() throws Exception {
        TreeMap<String, PageImpl> result = new TreeMap<String, PageImpl>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<PageImpl> pages = new ArrayList<PageImpl>(this.getChildrenContainer().values());
        for (int i = 0; i < pages.size(); ++i) {
            PageImpl page = (PageImpl)pages.get(i);
            if (page == null || !page.hasPermission(PermissionType.VIEWPAGE)) continue;
            result.put(page.getName(), page);
        }
        return result;
    }

    public Map<String, PageImpl> getChildrenByRootPermission() throws Exception {
        TreeMap<String, PageImpl> result = new TreeMap<String, PageImpl>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<PageImpl> pages = new ArrayList<PageImpl>(this.getChildrenContainer().values());
        for (int i = 0; i < pages.size(); ++i) {
            PageImpl page = (PageImpl)pages.get(i);
            if (page == null) continue;
            result.put(page.getTitle(), page);
        }
        return result;
    }

    @Property(name="isOverridePermission")
    public abstract boolean getOverridePermission();

    public abstract void setOverridePermission(boolean var1);

    @Override
    public boolean hasPermission(PermissionType permissionType) throws Exception {
        return this.permission.hasPermission(permissionType, this.getPath());
    }

    @Override
    public boolean hasPermission(PermissionType permissionType, Identity user) throws Exception {
        return this.permission.hasPermission(permissionType, this.getPath(), user);
    }

    @Override
    public HashMap<String, String[]> getPermission() throws Exception {
        return this.permission.getPermission(this.getPath());
    }

    @Override
    public void setPermission(HashMap<String, String[]> permissions) throws Exception {
        this.permission.setPermission(permissions, this.getPath());
    }

    @Override
    public void setNonePermission() throws Exception {
        this.setPermission(null);
    }

    protected void addPage(String pageName, Page page) {
        if (pageName == null) {
            throw new NullPointerException();
        }
        if (page == null) {
            throw new NullPointerException();
        }
        Map<String, PageImpl> children = this.getChildrenContainer();
        if (children.containsKey(pageName)) {
            throw new IllegalStateException();
        }
        children.put(pageName, (PageImpl)page);
    }

    @Override
    public void addWikiPage(Page page) {
        if (page == null) {
            throw new NullPointerException();
        }
        this.addPage(page.getName(), page);
    }

    @Override
    public void addPublicPage(Page page) throws Exception {
        this.addWikiPage(page);
        page.setNonePermission();
    }

    public PageImpl getWikiPage(String pageId) throws Exception {
        if ("WikiHome".equalsIgnoreCase(pageId)) {
            return this;
        }
        for (PageImpl page : this.getChildPages().values()) {
            if (!pageId.equals(page.getName())) continue;
            return page;
        }
        return null;
    }

    @Override
    public Wiki getWiki() {
        WikiHome wikiHome = this.getWikiHome();
        if (wikiHome != null) {
            PortalWiki portalWiki = wikiHome.getPortalWiki();
            GroupWiki groupWiki = wikiHome.getGroupWiki();
            UserWiki userWiki = wikiHome.getUserWiki();
            if (portalWiki != null) {
                return portalWiki;
            }
            if (groupWiki != null) {
                return groupWiki;
            }
            return userWiki;
        }
        return null;
    }

    public WikiHome getWikiHome() {
        PageImpl parent;
        if (this instanceof WikiHome) {
            parent = this;
        } else {
            for (parent = this.getParentPage(); parent != null && !(parent instanceof WikiHome); parent = parent.getParentPage()) {
            }
        }
        return (WikiHome)parent;
    }

    @Override
    public boolean isMinorEdit() {
        return this.isMinorEdit;
    }

    @Override
    public void setMinorEdit(boolean isMinorEdit) {
        this.isMinorEdit = isMinorEdit;
    }

    @Override
    @Destroy
    public abstract void remove();

    public synchronized String addRelatedPage(PageImpl page) throws Exception {
        Map<String, Value> referredUUIDs = this.getReferredUUIDs();
        Session jcrSession = this.getJCRSession();
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        Node referredJcrNode = (Node)jcrSession.getItem(page.getPath());
        String referedUUID = referredJcrNode.getUUID();
        if (referredUUIDs.containsKey(referedUUID)) {
            return null;
        }
        Value value2Add = jcrSession.getValueFactory().createValue(referredJcrNode);
        referredUUIDs.put(referedUUID, value2Add);
        myJcrNode.setProperty("exo:relation", referredUUIDs.values().toArray(new Value[referredUUIDs.size()]));
        myJcrNode.save();
        if (this.relatedPages != null) {
            this.relatedPages.add(page);
        }
        return referedUUID;
    }

    public List<PageImpl> getRelatedPages() throws Exception {
        if (this.relatedPages == null) {
            this.relatedPages = new ArrayList<PageImpl>();
            Iterator<Map.Entry<String, Value>> refferedIter = this.getReferredUUIDs().entrySet().iterator();
            ChromatticSession chSession = this.getChromatticSession();
            while (refferedIter.hasNext()) {
                Map.Entry<String, Value> entry = refferedIter.next();
                PageImpl page = (PageImpl)chSession.findById(PageImpl.class, entry.getValue().getString());
                if (page == null || !page.hasPermission(PermissionType.VIEWPAGE)) continue;
                this.relatedPages.add(page);
            }
        }
        return new ArrayList<PageImpl>(this.relatedPages);
    }

    public synchronized String removeRelatedPage(PageImpl page) throws Exception {
        Map<String, Value> referedUUIDs = this.getReferredUUIDs();
        Session jcrSession = this.getJCRSession();
        Node referredJcrNode = (Node)jcrSession.getItem(page.getPath());
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        String referredUUID = referredJcrNode.getUUID();
        if (!referedUUIDs.containsKey(referredUUID)) {
            return null;
        }
        referedUUIDs.remove(referredUUID);
        myJcrNode.setProperty("exo:relation", referedUUIDs.values().toArray(new Value[referedUUIDs.size()]));
        myJcrNode.save();
        if (this.relatedPages != null) {
            this.relatedPages.remove(page);
        }
        return referredUUID;
    }

    public Map<String, Value> getReferredUUIDs() throws Exception {
        Value[] values;
        Session jcrSession = this.getJCRSession();
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        HashMap<String, Value> referedUUIDs = new HashMap<String, Value>();
        if (myJcrNode.hasProperty("exo:relation") && (values = myJcrNode.getProperty("exo:relation").getValues()) != null && values.length > 0) {
            for (Value value : values) {
                referedUUIDs.put(value.getString(), value);
            }
        }
        return referedUUIDs;
    }

    public synchronized void removeAllRelatedPages() throws Exception {
        Session jcrSession = this.getJCRSession();
        Node myJcrNode = (Node)jcrSession.getItem(this.getPath());
        myJcrNode.setProperty("exo:relation", (Value[])null);
        myJcrNode.save();
        if (this.relatedPages != null) {
            this.relatedPages.clear();
        }
    }
}

