/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;

public class ArrayNodePageList<E>
extends AbstractPageList<E> {
    private static final Log LOG = ExoLogger.getLogger((String)ArrayNodePageList.class.getName());
    protected List<E> dataList;

    public ArrayNodePageList(int pageSize) {
        super(pageSize);
        this.removeRedundantPages(0);
    }

    public ArrayNodePageList(List<E> nodes, int pageSize) {
        super(pageSize);
        this.setTotalNodes(nodes.size());
        this.dataList = nodes;
        this.setAvailablePage(this.dataList.size());
        this.removeRedundantPages(this.dataList.size() / pageSize);
        this.currentListPage_ = null;
    }

    public ArrayNodePageList(List<Node> nodes, int pageSize, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) {
        block4: {
            super(pageSize, filter, dataCreator);
            this.setTotalNodes(nodes.size());
            this.dataList = new ArrayList();
            try {
                for (Node node : nodes) {
                    Object data;
                    if (filter != null) {
                        node = filter.filterNodeToDisplay(node);
                    }
                    if (this.searchDataCreator == null || node == null || (data = this.searchDataCreator.createData(node, null)) == null) continue;
                    this.dataList.add(data);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage());
            }
        }
        this.setAvailablePage(this.dataList.size());
        this.removeRedundantPages(this.dataList.size() / pageSize);
        this.currentListPage_ = null;
    }

    public ArrayNodePageList(QueryResult queryResult, int pageSize, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) {
        block4: {
            super(pageSize, filter, dataCreator);
            this.dataList = new ArrayList();
            try {
                this.setTotalNodes(queryResult.getNodes().getSize());
                NodeIterator nodeIterator = queryResult.getNodes();
                RowIterator rowIterator = queryResult.getRows();
                while (nodeIterator.hasNext()) {
                    Object data;
                    Node node = nodeIterator.nextNode();
                    if (filter != null) {
                        node = filter.filterNodeToDisplay(node);
                    }
                    Row row = rowIterator.nextRow();
                    if (this.searchDataCreator == null || node == null || (data = this.searchDataCreator.createData(node, row)) == null) continue;
                    this.dataList.add(data);
                }
                this.dataList = this.removeDuplication(this.dataList);
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)e.getMessage());
            }
        }
        this.setAvailablePage(this.dataList.size());
        this.removeRedundantPages(this.dataList.size() / pageSize);
        this.currentListPage_ = null;
    }

    public List<E> getDataList() {
        return this.dataList;
    }

    public List<E> getAll() throws Exception {
        return this.getDataList();
    }

    protected void populateCurrentPage(int page) throws Exception {
        this.currentListPage_ = new ArrayList();
        int count = 0;
        if (this.dataList != null) {
            for (int i = (page - 1) * this.getPageSize(); i < this.dataList.size(); ++i) {
                this.currentListPage_.add(this.dataList.get(i));
                if (++count == this.getPageSize()) break;
            }
        }
        this.currentPage_ = page;
    }

    @Override
    public void sortData() {
        block3: {
            if (this.comparator != null) {
                Collections.sort(this.dataList, this.comparator);
                try {
                    this.populateCurrentPage(this.currentPage_);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
    }

    private List<E> removeDuplication(List<E> srcList) {
        ArrayList<E> ret = new ArrayList<E>();
        HashSet<E> set = new HashSet<E>();
        if (srcList != null) {
            for (E elem : srcList) {
                if (set.contains(elem)) continue;
                set.add(elem);
                ret.add(elem);
            }
        }
        return ret;
    }
}

