/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    private final Promise<JoinRsp> join_promise = new Promise();

    public ClientGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.join_promise.reset();
    }

    @Override
    public void join(Address address) {
        this.join(address, false);
    }

    @Override
    public void joinWithStateTransfer(Address address) {
        this.join(address, true);
    }

    private void join(Address mbr, boolean joinWithStateTransfer) {
        Address coord = null;
        JoinRsp rsp = null;
        this.leaving = false;
        this.join_promise.reset();
        while (!this.leaving) {
            if (rsp == null && !this.join_promise.hasResult()) {
                List<PingRsp> responses = this.findInitialMembers(this.join_promise);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("initial_mbrs are " + responses));
                }
                if (responses == null || responses.isEmpty()) {
                    if (this.gms.disable_initial_coord) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace((Object)"received an initial membership of 0, but cannot become coordinator (disable_initial_coord=true), will retry fetching the initial membership");
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"no initial members discovered: creating group as first member");
                    }
                    this.becomeSingletonMember(mbr);
                    return;
                }
                coord = this.determineCoord(responses);
                if (coord == null) {
                    Address new_coord;
                    if (!this.gms.handle_concurrent_startup) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"handle_concurrent_startup is false; ignoring responses of initial clients");
                        }
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("could not determine coordinator from responses " + responses));
                    }
                    TreeSet<Address> clients = new TreeSet<Address>();
                    clients.add(mbr);
                    for (PingRsp response : responses) {
                        Address client_addr = response.getAddress();
                        if (client_addr == null) continue;
                        clients.add(client_addr);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("clients to choose new coord from are: " + clients));
                    }
                    if ((new_coord = (Address)clients.iterator().next()).equals(mbr)) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("I (" + mbr + ") am the first of the clients, will become coordinator"));
                        }
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("I (" + mbr + ") am not the first of the clients, waiting for another client to become coordinator"));
                    }
                    Util.sleep(500L);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sending handleJoin(" + mbr + ") to " + coord));
                }
                this.sendJoinMessage(coord, mbr, joinWithStateTransfer);
            }
            try {
                if (rsp == null) {
                    rsp = this.join_promise.getResult(this.gms.join_timeout);
                }
                if (rsp == null) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("join(" + mbr + ") sent to " + coord + " timed out (after " + this.gms.join_timeout + " ms), retrying"));
                    continue;
                }
                String failure = rsp.getFailReason();
                if (failure != null) {
                    throw new SecurityException(failure);
                }
                if (rsp.getDigest() == null || rsp.getDigest().getSenders() == null) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)("digest response has no senders: digest=" + rsp.getDigest()));
                    }
                    rsp = null;
                    continue;
                }
                MutableDigest tmp_digest = new MutableDigest(rsp.getDigest());
                View tmp_view = rsp.getView();
                if (tmp_view == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"JoinRsp has a null view, skipping it");
                    }
                    rsp = null;
                    continue;
                }
                if (!tmp_digest.contains(this.gms.local_addr)) {
                    throw new IllegalStateException("digest returned from " + coord + " with JOIN_RSP does not contain myself (" + this.gms.local_addr + "): join response: " + rsp);
                }
                tmp_digest.incrementHighestDeliveredSeqno(coord);
                tmp_digest.seal();
                this.gms.setDigest(tmp_digest);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[" + this.gms.local_addr + "]: JoinRsp=" + tmp_view + " [size=" + tmp_view.size() + "]\n\n"));
                }
                if (!this.installView(tmp_view)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"view installation failed, retrying to join group");
                    }
                    rsp = null;
                    continue;
                }
                Message view_ack = new Message(coord, null, null);
                view_ack.setFlag((byte)1);
                GMS.GmsHeader tmphdr = new GMS.GmsHeader(10);
                view_ack.putHeader("GMS", tmphdr);
                this.gms.getDownProtocol().down(new Event(1, view_ack));
                return;
            }
            catch (SecurityException security_ex) {
                throw security_ex;
            }
            catch (IllegalArgumentException illegal_arg) {
                throw illegal_arg;
            }
            catch (Throwable e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("exception=" + e + ", retrying"));
                }
                rsp = null;
            }
        }
    }

    private List<PingRsp> findInitialMembers(Promise<JoinRsp> promise) {
        List responses = (List)this.gms.getDownProtocol().down(new Event(12, promise));
        if (responses != null) {
            Iterator iter = responses.iterator();
            while (iter.hasNext()) {
                PingRsp response = (PingRsp)iter.next();
                if (response.own_addr == null || !response.own_addr.equals(this.gms.local_addr)) continue;
                iter.remove();
            }
        }
        return responses;
    }

    @Override
    public void leave(Address mbr) {
        this.leaving = true;
        this.wrongMethod("leave");
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        this.join_promise.setResult(join_rsp);
    }

    @Override
    public void handleLeaveResponse() {
    }

    @Override
    public void suspect(Address mbr) {
    }

    @Override
    public void unsuspect(Address mbr) {
    }

    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
    }

    @Override
    public synchronized void handleViewChange(View new_view, Digest digest) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("view " + new_view.getVid() + " is discarded as we are not a participant"));
        }
    }

    private boolean installView(View new_view) {
        Vector<Address> mems = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("new_view=" + new_view));
        }
        if (this.gms.local_addr == null || mems == null || !mems.contains(this.gms.local_addr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("I (" + this.gms.local_addr + ") am not member of " + mems + ", will not install view"));
            }
            return false;
        }
        this.gms.installView(new_view);
        this.gms.becomeParticipant();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        return true;
    }

    void sendJoinMessage(Address coord, Address mbr, boolean joinWithTransfer) {
        Message msg = new Message(coord, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = joinWithTransfer ? new GMS.GmsHeader(11, mbr) : new GMS.GmsHeader(1, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private Address determineCoord(List<PingRsp> mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        HashMap<Address, Integer> votes = new HashMap<Address, Integer>(5);
        for (PingRsp pingRsp : mbrs) {
            if (!pingRsp.is_server || pingRsp.coord_addr == null) continue;
            if (!votes.containsKey(pingRsp.coord_addr)) {
                votes.put(pingRsp.coord_addr, 1);
                continue;
            }
            count = (Integer)votes.get(pingRsp.coord_addr);
            votes.put(pingRsp.coord_addr, count + 1);
        }
        if (votes.size() > 1) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("there was more than 1 candidate for coordinator: " + votes));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("election results: " + votes));
        }
        int most_votes = 0;
        for (Map.Entry entry : votes.entrySet()) {
            Address tmp = (Address)entry.getKey();
            count = (Integer)entry.getValue();
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    void becomeSingletonMember(Address mbr) {
        Vector<Address> mbrs = new Vector<Address>(1);
        Digest initial_digest = new Digest(this.gms.local_addr, 0L, 0L);
        this.gms.setDigest(initial_digest);
        ViewId view_id = new ViewId(mbr);
        mbrs.addElement(mbr);
        this.gms.installView(new View(view_id, mbrs));
        this.gms.becomeCoordinator();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("created group (first member). My view is " + this.gms.view_id + ", impl is " + this.gms.getImpl().getClass().getName()));
        }
    }
}

