/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.Iterator;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.chromattic.entity.ProviderRootEntity;
import org.exoplatform.social.core.chromattic.entity.SpaceRootEntity;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;

public abstract class AbstractStorage {
    protected final SocialChromatticLifeCycle lifeCycle = AbstractStorage.lifecycleLookup();
    protected static final String NS_JCR = "jcr:";
    protected static final String NODETYPE_PROVIDERS = "soc:providers";
    protected static final String NODETYPE_SPACES = "soc:spaces";
    protected static final String SENDER = "sender";
    protected static final String RECEIVER = "receiver";

    protected AbstractStorage() {
    }

    protected ChromatticSession getSession() {
        return this.lifeCycle.getSession();
    }

    private <T> T getRoot(String nodetypeName, Class<T> t) {
        Object got = this.getSession().findByPath(t, nodetypeName);
        if (got == null) {
            got = this.getSession().insert(t, nodetypeName);
        }
        return (T)got;
    }

    protected ProviderRootEntity getProviderRoot() {
        if (this.lifeCycle.getProviderRoot().get() == null) {
            this.lifeCycle.getProviderRoot().set(this.getRoot(NODETYPE_PROVIDERS, ProviderRootEntity.class));
        }
        return (ProviderRootEntity)this.lifeCycle.getProviderRoot().get();
    }

    protected SpaceRootEntity getSpaceRoot() {
        if (this.lifeCycle.getSpaceRoot().get() == null) {
            this.lifeCycle.getSpaceRoot().set(this.getRoot(NODETYPE_SPACES, SpaceRootEntity.class));
        }
        return (SpaceRootEntity)this.lifeCycle.getSpaceRoot().get();
    }

    protected <T> T _findById(Class<T> clazz, String nodeId) throws NodeNotFoundException {
        if (nodeId == null) {
            throw new NodeNotFoundException("null id cannot be found");
        }
        Object got = this.getSession().findById(clazz, nodeId);
        if (got == null) {
            throw new NodeNotFoundException(nodeId + " doesn't exists");
        }
        return (T)got;
    }

    protected <T> T _findByPath(Class<T> clazz, String nodePath) throws NodeNotFoundException {
        if (nodePath == null) {
            throw new NodeNotFoundException("null nodePath cannot be found");
        }
        Object got = this.getSession().findByPath(clazz, nodePath, true);
        if (got == null) {
            throw new NodeNotFoundException(nodePath + " doesn't exists");
        }
        return (T)got;
    }

    protected void _removeById(Class<?> clazz, String nodeId) {
        this.getSession().remove(this.getSession().findById(clazz, nodeId));
    }

    protected boolean isJcrProperty(String name) {
        return !name.startsWith(NS_JCR);
    }

    protected void _skip(Iterator<?> it, long offset) {
        while (it.hasNext()) {
            if (offset == 0L) {
                return;
            }
            it.next();
            --offset;
        }
    }

    protected <M> M _getMixin(Object o, Class<M> mixinType, boolean create) {
        Object mixin = this.getSession().getEmbedded(o, mixinType);
        if (mixin == null && create) {
            mixin = this.getSession().create(mixinType);
            this.getSession().setEmbedded(o, mixinType, mixin);
        }
        return (M)mixin;
    }

    protected <M> boolean _removeMixin(Object o, Class<M> mixinType) {
        Object mixin = this.getSession().getEmbedded(o, mixinType);
        if (mixin != null) {
            this.getSession().setEmbedded(o, mixinType, null);
            return true;
        }
        return false;
    }

    public static boolean startSynchronization() {
        SocialChromatticLifeCycle lc = AbstractStorage.lifecycleLookup();
        if (lc.getManager().getSynchronization() == null) {
            lc.getManager().beginRequest();
            return true;
        }
        return false;
    }

    public static void stopSynchronization(boolean requestClose) {
        SocialChromatticLifeCycle lc = AbstractStorage.lifecycleLookup();
        if (requestClose) {
            lc.getManager().endRequest(true);
        }
    }

    private static SocialChromatticLifeCycle lifecycleLookup() {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        return (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
    }
}

