/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.forum.common.jcr.JCRListAccess;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.common.jcr.SessionManager;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;

public class TopicListAccess
extends JCRListAccess<Topic> {
    String topicQuery;

    public TopicListAccess(SessionManager sessionManager, String topicQuery) {
        super(sessionManager);
        this.topicQuery = topicQuery;
    }

    protected int getSize(Session session) throws Exception {
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(this.topicQuery, "xpath");
        QueryResultImpl result = (QueryResultImpl)query.execute();
        return result.getTotalSize();
    }

    protected Topic[] load(Session session, int index, int length) throws Exception, IllegalArgumentException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(this.topicQuery, "xpath");
        query.setCaseInsensitiveOrder(true);
        query.setOffset((long)index);
        query.setLimit((long)(index + length));
        QueryResult result = query.execute();
        ArrayList<Topic> topicList = new ArrayList<Topic>();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            topicList.add(this.getTopic(iter.nextNode()));
        }
        Topic[] topics = topicList.toArray(new Topic[topicList.size()]);
        return topics;
    }

    private Topic getTopic(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        PropertyReader reader = new PropertyReader(topicNode);
        Topic topicNew = new Topic();
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setOwner(reader.string("exo:owner"));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setDescription(reader.string("exo:description"));
        topicNew.setPostCount(reader.l("exo:postCount"));
        topicNew.setViewCount(reader.l("exo:viewCount"));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        topicNew.setIsSticky(reader.bool("exo:isSticky"));
        if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
            topicNew.setIsLock(true);
        } else {
            topicNew.setIsLock(reader.bool("exo:isLock"));
        }
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setNumberAttachment(reader.l("exo:numberAttachments"));
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setIsModeratePost(reader.bool("exo:isModeratePost"));
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        topicNew.setIsWaiting(reader.bool("exo:isWaiting"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setVoteRating(reader.d("exo:voteRating"));
        topicNew.setUserVoteRating(reader.strings("exo:userVoteRating"));
        return topicNew;
    }
}

