/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeLinkAware
implements NodeType {
    private static final Log LOG = ExoLogger.getLogger((String)NodeTypeLinkAware.class.getName());
    private final String name;
    private NodeLinkAware node;
    private volatile NodeType targetNodeType;

    NodeTypeLinkAware(NodeLinkAware node) throws RepositoryException {
        this.node = node;
        Node realNode = node.getRealNode();
        LinkManager manager = LinkUtils.getLinkManager();
        this.name = manager.isLink((Item)realNode) ? manager.getTargetPrimaryNodeType(realNode) : realNode.getPrimaryNodeType().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeType getTargetNodeType() throws RepositoryException {
        if (this.targetNodeType == null) {
            NodeTypeLinkAware nodeTypeLinkAware = this;
            synchronized (nodeTypeLinkAware) {
                if (this.targetNodeType == null) {
                    this.targetNodeType = this.node.getTarget().getPrimaryNodeType();
                    this.node = null;
                }
            }
        }
        return this.targetNodeType;
    }

    public boolean canAddChildNode(String childNodeName) {
        try {
            return this.getTargetNodeType().canAddChildNode(childNodeName);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            return this.getTargetNodeType().canAddChildNode(childNodeName, nodeTypeName);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }

    public boolean canRemoveItem(String itemName) {
        try {
            return this.getTargetNodeType().canRemoveItem(itemName);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value value) {
        try {
            return this.getTargetNodeType().canSetProperty(propertyName, value);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        try {
            return this.getTargetNodeType().canSetProperty(propertyName, values);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        try {
            return this.getTargetNodeType().getChildNodeDefinitions();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        try {
            return this.getTargetNodeType().getDeclaredChildNodeDefinitions();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        try {
            return this.getTargetNodeType().getDeclaredPropertyDefinitions();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public NodeType[] getDeclaredSupertypes() {
        try {
            return this.getTargetNodeType().getDeclaredSupertypes();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrimaryItemName() {
        try {
            return this.getTargetNodeType().getPrimaryItemName();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        try {
            return this.getTargetNodeType().getPropertyDefinitions();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public NodeType[] getSupertypes() {
        try {
            return this.getTargetNodeType().getSupertypes();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public boolean hasOrderableChildNodes() {
        try {
            return this.getTargetNodeType().hasOrderableChildNodes();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }

    public boolean isMixin() {
        return false;
    }

    public boolean isNodeType(String nodeTypeName) {
        try {
            return this.getTargetNodeType().isNodeType(nodeTypeName);
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return false;
        }
    }
}

