/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;
import org.xwiki.rendering.syntax.Syntax;

public class WikiSpaceActivityPublisher
extends PageWikiListener {
    public static final String WIKI_APP_ID = "ks-wiki:spaces";
    public static final String ACTIVITY_TYPE_KEY = "act_key";
    public static final String PAGE_ID_KEY = "page_id";
    public static final String PAGE_TYPE_KEY = "page_type";
    public static final String PAGE_OWNER_KEY = "page_owner";
    public static final String PAGE_TITLE_KEY = "page_name";
    public static final String URL_KEY = "page_url";
    public static final String PAGE_EXCERPT = "page_exceprt";
    public static final String VIEW_CHANGE_URL_KEY = "view_change_url";
    public static final String VIEW_CHANGE_ANCHOR = "#CompareRevision/changes";
    public static final String WIKI_PAGE_NAME = "wiki";
    public static final String WIKI_PAGE_VERSION = "version";
    private static final int EXCERPT_LENGTH = 140;
    private static final Log LOG = ExoLogger.getExoLogger(WikiSpaceActivityPublisher.class);

    private ExoSocialActivityImpl createNewActivity(String ownerId) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(ownerId);
        activity.setTitle("title");
        activity.setBody("body");
        activity.setType(WIKI_APP_ID);
        return activity;
    }

    private ExoSocialActivity generateActivity(Identity ownerStream, Identity ownerIdentity, String wikiType, String wikiOwner, String pageId, Page page, String spaceUrl, String activityType) throws Exception {
        Node node = page.getJCRPageNode();
        ExoSocialActivity activity = null;
        boolean isNewActivity = false;
        ActivityManager activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            try {
                String nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
                activity = activityManager.getActivity(nodeActivityID);
                isNewActivity = false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (activity == null) {
            if (page.isMinorEdit()) {
                return null;
            }
            activity = this.createNewActivity(ownerIdentity.getId());
            isNewActivity = true;
        }
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(PAGE_ID_KEY, pageId);
        templateParams.put(ACTIVITY_TYPE_KEY, activityType);
        templateParams.put(PAGE_OWNER_KEY, wikiOwner);
        templateParams.put(PAGE_TYPE_KEY, wikiType);
        templateParams.put(PAGE_TITLE_KEY, page.getTitle());
        String pageURL = page.getURL() == null ? (spaceUrl != null ? spaceUrl + "/" + WIKI_PAGE_NAME : "") : page.getURL();
        templateParams.put(URL_KEY, pageURL);
        int versionsTotal = page.getVersionableMixin().getVersionHistory().getChildren().size() - 1;
        templateParams.put(WIKI_PAGE_VERSION, String.valueOf(versionsTotal));
        StringBuffer excerpt = new StringBuffer();
        RenderingService renderingService = (RenderingService)PortalContainer.getInstance().getComponentInstanceOfType(RenderingService.class);
        excerpt.append(renderingService.render(page.getContent().getText(), page.getSyntax(), Syntax.PLAIN_1_0.toIdString(), false));
        if (excerpt.length() > 140) {
            excerpt.replace(140, excerpt.length(), "...");
        }
        templateParams.put(PAGE_EXCERPT, this.validateExcerpt(excerpt.toString()));
        templateParams.put("registeredKeysForProcessor", PAGE_EXCERPT);
        if (!"add_page".equals(activityType)) {
            String verName = ((PageImpl)page).getVersionableMixin().getBaseVersion().getName();
            templateParams.put(VIEW_CHANGE_URL_KEY, Utils.getURL((String)page.getURL(), (String)verName));
        }
        activity.setTemplateParams(templateParams);
        if (isNewActivity) {
            activityManager.saveActivityNoReturn(ownerStream, activity);
        } else {
            activityManager.updateActivity(activity);
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        if (!"add_page".equals(activityType)) {
            if ("editPageTitle".equals(activityType) && !page.isMinorEdit()) {
                this.createAndSaveComment(activity, res.getString("WikiUIActivity.msg.update-page-title") + page.getTitle(), ownerIdentity.getId());
            } else if ("editPageContent".equals(activityType) && !page.isMinorEdit()) {
                String comment = page.getComment();
                if (StringUtils.isEmpty((String)comment)) {
                    this.createAndSaveComment(activity, res.getString("WikiUIActivity.msg.update-page-content"), ownerIdentity.getId());
                } else {
                    this.createAndSaveComment(activity, comment, ownerIdentity.getId());
                }
            } else if ("editPageContentAndTitle".equals(activityType) && !page.isMinorEdit()) {
                StringBuffer commentContent = new StringBuffer();
                commentContent.append(res.getString("WikiUIActivity.msg.update-page-title"));
                commentContent.append(page.getTitle());
                commentContent.append("<br>");
                String comment = page.getComment();
                if (StringUtils.isEmpty((String)comment)) {
                    commentContent.append(res.getString("WikiUIActivity.msg.update-page-content"));
                } else {
                    commentContent.append(comment);
                }
                this.createAndSaveComment(activity, commentContent.toString(), ownerIdentity.getId());
            } else if ("movePage".equals(activityType)) {
                WikiService wikiService = (WikiService)PortalContainer.getInstance().getComponentInstanceOfType(WikiService.class);
                List breadcrumbDatas = wikiService.getBreadcumb(wikiType, wikiOwner, pageId);
                StringBuffer breadcrumText = new StringBuffer();
                for (int i = 0; i < breadcrumbDatas.size(); ++i) {
                    breadcrumText.append(((BreadcrumbData)breadcrumbDatas.get(i)).getTitle());
                    if (i >= breadcrumbDatas.size() - 1) continue;
                    breadcrumText.append(" > ");
                }
                this.createAndSaveComment(activity, res.getString("WikiUIActivity.msg.move-page") + breadcrumText.toString(), ownerIdentity.getId());
            }
        }
        return activity;
    }

    private String validateExcerpt(String excerpt) {
        String[] lines = excerpt.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 140) continue;
            lines[i] = lines[i].substring(0, 140) + "...";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < Math.min(lines.length, 4); ++i) {
            result.append(lines[i]);
            result.append("\n");
        }
        if (lines.length > 4) {
            result.append("...");
        }
        return result.toString();
    }

    private void createAndSaveComment(ExoSocialActivity activity, String comment, String userId) {
        ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        ExoSocialActivityImpl newComment = new ExoSocialActivityImpl();
        newComment.setTitle(comment);
        newComment.setUserId(userId);
        activityM.saveComment(activity, (ExoSocialActivity)newComment);
    }

    private boolean isPublic(Page page) throws Exception {
        HashMap permissions = page.getPermission();
        return permissions != null && permissions.containsKey(IdentityConstants.ANY) && ArrayUtils.contains((Object[])((Object[])permissions.get(IdentityConstants.ANY)), (Object)"read");
    }

    private boolean isPublicInSpace(Page page, Space space) throws Exception {
        String groupMemberShip;
        HashMap pagePermissions = page.getPermission();
        return pagePermissions.containsKey(groupMemberShip = "*:" + space.getGroupId()) && ArrayUtils.contains((Object[])((Object[])pagePermissions.get(groupMemberShip)), (Object)"read");
    }

    private void saveActivity(String wikiType, String wikiOwner, String pageId, Page page, String activityType) throws Exception {
        String spaceUrl;
        ExoSocialActivity activity;
        Identity authorActivity;
        Identity ownerStream;
        Identity userIdentity;
        block13: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            if (PortalConfig.USER_TYPE.equals(wikiType) || !this.isPublic(page)) {
                return;
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            userIdentity = identityM.getOrCreateIdentity("organization", username, false);
            ownerStream = null;
            authorActivity = userIdentity;
            activity = null;
            spaceUrl = null;
            if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                Space space = null;
                try {
                    space = spaceService.getSpaceByGroupId(wikiOwner);
                    if (space != null) {
                        if (!this.isPublicInSpace(page, space)) {
                            return;
                        }
                        ownerStream = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
                        spaceUrl = space.getUrl();
                    }
                }
                catch (SpaceStorageException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug((Object)String.format("Space %s not existed", wikiOwner), (Throwable)e);
                }
            }
        }
        if (ownerStream == null) {
            ownerStream = userIdentity;
        }
        if (ownerStream != null) {
            activity = this.generateActivity(ownerStream, authorActivity, wikiType, wikiOwner, pageId, page, spaceUrl, activityType);
            if (activity == null) {
                return;
            }
            Node node = page.getJCRPageNode();
            String activityId = activity.getId();
            if (!StringUtils.isEmpty((String)activityId)) {
                ActivityTypeUtils.attachActivityId((Node)node, (String)activityId);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        if ("WikiHome".equals(pageId)) {
            return;
        }
        this.saveActivity(wikiType, wikiOwner, pageId, page, "add_page");
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        Node node = page.getJCRPageNode();
        ActivityManager activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
        if (node.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) {
            String nodeActivityID = node.getProperty(ActivityTypeUtils.EXO_ACTIVITY_ID).getString();
            activityManager.deleteActivity(nodeActivityID);
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, String wikiUpdateType) throws Exception {
        if (page != null) {
            this.saveActivity(wikiType, wikiOwner, pageId, page, wikiUpdateType);
        }
    }
}

