/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.resolver.PageResolver;
import org.exoplatform.wiki.service.WikiService;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wiki/social-integration/plugin/space/WikiUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})
public class WikiUIActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(WikiUIActivity.class);

    public String getUriOfAuthor() {
        if (this.getOwnerIdentity() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get Url of user, author isn't set");
            }
            return "";
        }
        return "<a href='" + this.getOwnerIdentity().getProfile().getUrl() + "'>" + this.getOwnerIdentity().getProfile().getFullName() + "</a>";
    }

    public String getUserFullName(String userId) {
        return this.getOwnerIdentity().getProfile().getFullName();
    }

    public String getUserProfileUri(String userId) {
        return this.getOwnerIdentity().getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            if (this.getOwnerIdentity() == null) {
                LOG.error((Object)"Failed to get Space Avatar Source, unknow owner identity.");
                return null;
            }
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (SpaceStorageException e) {
            LOG.error((Object)String.format("Failed to getSpaceById: %s. \n Cause by: ", spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    String getActivityMessage(WebuiBindingContext _ctx) throws Exception {
        return _ctx.appRes("WikiUIActivity.label.page-create");
    }

    String getPageName() {
        return this.getActivityParamValue("page_name");
    }

    String getPageURL() {
        String pageUrl = this.getActivityParamValue("page_url");
        if (pageUrl != null) {
            try {
                URL oldURL = new URL(pageUrl);
                pageUrl = oldURL.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return pageUrl;
    }

    String getViewChangeURL() {
        return this.getActivityParamValue("view_change_url");
    }

    String getPageExcerpt() {
        return this.getActivityParamValue("page_exceprt");
    }

    String getPageVersion() {
        String version = this.getActivityParamValue("version");
        if (StringUtils.isEmpty((String)version)) {
            version = "1";
            String pageUrl = this.getPageURL();
            if (pageUrl == null) {
                return version;
            }
            PageResolver pageResolver = (PageResolver)PortalContainer.getComponent(PageResolver.class);
            WikiService wikiService = (WikiService)PortalContainer.getInstance().getComponentInstanceOfType(WikiService.class);
            try {
                Page page;
                Page wikiHome = pageResolver.resolve(pageUrl, Util.getUIPortal().getSelectedUserNode());
                if (wikiHome != null && (page = wikiService.getPageById(wikiHome.getWiki().getType(), wikiHome.getWiki().getOwner(), pageUrl.substring(pageUrl.lastIndexOf(47) + 1))) != null) {
                    version = String.valueOf(page.getVersionableMixin().getVersionHistory().getChildren().size() - 1);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to get version of wiki page", (Throwable)e);
            }
        }
        return version;
    }
}

