/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;

class SummaryExtractor {
    private static final String SUMMARY_INFORMATION = "\u0005SummaryInformation";
    private static final String DOCUMENT_SUMMARY_INFORMATION = "\u0005DocumentSummaryInformation";
    private final Metadata metadata;

    public SummaryExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public void parseSummaries(NPOIFSFileSystem filesystem) throws IOException, TikaException {
        this.parseSummaries(filesystem.getRoot());
    }

    public void parseSummaries(DirectoryNode root) throws IOException, TikaException {
        this.parseSummaryEntryIfExists(root, SUMMARY_INFORMATION);
        this.parseSummaryEntryIfExists(root, DOCUMENT_SUMMARY_INFORMATION);
    }

    private void parseSummaryEntryIfExists(DirectoryNode root, String entryName) throws IOException, TikaException {
        try {
            DocumentEntry entry = (DocumentEntry)root.getEntry(entryName);
            PropertySet properties = new PropertySet((InputStream)new DocumentInputStream(entry));
            if (properties.isSummaryInformation()) {
                this.parse(new SummaryInformation(properties));
            }
            if (properties.isDocumentSummaryInformation()) {
                this.parse(new DocumentSummaryInformation(properties));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (NoPropertySetStreamException e) {
        }
        catch (UnexpectedPropertySetTypeException e) {
            throw new TikaException("Unexpected HPSF document", (Throwable)e);
        }
        catch (MarkUnsupportedException e) {
            throw new TikaException("Invalid DocumentInputStream", (Throwable)e);
        }
    }

    private void parse(SummaryInformation summary) {
        this.set("title", summary.getTitle());
        this.set("Author", summary.getAuthor());
        this.set("Keywords", summary.getKeywords());
        this.set("subject", summary.getSubject());
        this.set("Last-Author", summary.getLastAuthor());
        this.set("Comments", summary.getComments());
        this.set("Template", summary.getTemplate());
        this.set("Application-Name", summary.getApplicationName());
        this.set("Revision-Number", summary.getRevNumber());
        this.set(Metadata.CREATION_DATE, summary.getCreateDateTime());
        this.set(Metadata.CHARACTER_COUNT, summary.getCharCount());
        this.set("Edit-Time", summary.getEditTime());
        this.set(Metadata.LAST_SAVED, summary.getLastSaveDateTime());
        this.set(Metadata.PAGE_COUNT, summary.getPageCount());
        if (summary.getPageCount() > 0) {
            this.metadata.set(PagedText.N_PAGES, summary.getPageCount());
        }
        this.set("Security", (long)summary.getSecurity());
        this.set(Metadata.WORD_COUNT, summary.getWordCount());
        this.set(Metadata.LAST_PRINTED, summary.getLastPrinted());
    }

    private void parse(DocumentSummaryInformation summary) {
        this.set("Company", summary.getCompany());
        this.set("Manager", summary.getManager());
        this.set("language", this.getLanguage(summary));
        this.set("Category", summary.getCategory());
        this.set(Metadata.SLIDE_COUNT, summary.getSlideCount());
        if (summary.getSlideCount() > 0) {
            this.metadata.set(PagedText.N_PAGES, summary.getSlideCount());
        }
        this.parse(summary.getCustomProperties());
    }

    private String getLanguage(DocumentSummaryInformation summary) {
        Object value;
        CustomProperties customProperties = summary.getCustomProperties();
        if (customProperties != null && (value = customProperties.get("Language")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private void parse(CustomProperties customProperties) {
        if (customProperties != null) {
            for (String name : customProperties.nameSet()) {
                Property prop;
                String key = "custom:" + name;
                Object value = customProperties.get(name);
                if (value instanceof String) {
                    this.set(key, (String)value);
                    continue;
                }
                if (value instanceof Date) {
                    prop = Property.externalDate((String)key);
                    this.metadata.set(prop, (Date)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    prop = Property.externalBoolean((String)key);
                    this.metadata.set(prop, ((Boolean)value).toString());
                    continue;
                }
                if (value instanceof Long) {
                    prop = Property.externalInteger((String)key);
                    this.metadata.set(prop, ((Long)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    prop = Property.externalReal((String)key);
                    this.metadata.set(prop, ((Double)value).doubleValue());
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                prop = Property.externalInteger((String)key);
                this.metadata.set(prop, ((Integer)value).intValue());
            }
        }
    }

    private void set(String name, String value) {
        if (value != null) {
            this.metadata.set(name, value);
        }
    }

    private void set(Property property, Date value) {
        if (value != null) {
            this.metadata.set(property, value);
        }
    }

    private void set(Property property, int value) {
        if (value > 0) {
            this.metadata.set(property, value);
        }
    }

    private void set(String name, long value) {
        if (value > 0L) {
            this.metadata.set(name, Long.toString(value));
        }
    }
}

