/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.CompoundApplicationMessage;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MultipleConditionsValidator;

@Serialized
public class EmailAddressValidator
extends MultipleConditionsValidator {
    @Override
    protected void validate(String value, String label, CompoundApplicationMessage messages, UIFormInput uiInput) {
        Object[] args = new Object[]{label};
        int atIndex = value.indexOf(64);
        if (atIndex == -1) {
            messages.addMessage("EmailAddressValidator.msg.Invalid-input", args);
        } else {
            String localPart = value.substring(0, atIndex);
            String domainName = value.substring(atIndex + 1);
            if (!this.validateLocalPart(localPart.toCharArray()) || !this.validateDomainName(domainName.toCharArray())) {
                messages.addMessage("EmailAddressValidator.msg.Invalid-input", args);
            }
        }
    }

    private boolean validateLocalPart(char[] localPart) {
        if (localPart.length == 0 || !Character.isLetter(localPart[0]) || !Character.isLetterOrDigit(localPart[localPart.length - 1])) {
            return false;
        }
        for (int i = 1; i < localPart.length - 1; ++i) {
            char c = localPart[i];
            char next = localPart[i + 1];
            if (Character.isLetterOrDigit(c) || this.isLocalPartSymbol(c) && Character.isLetterOrDigit(next)) continue;
            return false;
        }
        return true;
    }

    private boolean validateDomainName(char[] domainName) {
        if (domainName.length == 0 || !Character.isLetter(domainName[0]) || !Character.isLetterOrDigit(domainName[domainName.length - 1])) {
            return false;
        }
        boolean foundValidLastDot = false;
        for (int i = 1; i < domainName.length - 1; ++i) {
            char c = domainName[i];
            char next = domainName[i + 1];
            if (c == '.') {
                foundValidLastDot = true;
            } else if (!Character.isLetter(c)) {
                foundValidLastDot = false;
            }
            if (Character.isLetterOrDigit(c) || this.isDomainNameSymbol(c) && Character.isLetterOrDigit(next)) continue;
            return false;
        }
        return foundValidLastDot;
    }

    private boolean isLocalPartSymbol(char c) {
        return c == '-' || c == '_' || c == '.';
    }

    private boolean isDomainNameSymbol(char c) {
        return c == '-' || c == '.';
    }
}

