/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gatein.management.api.FilteredAddress;
import org.gatein.management.api.PathAddress;

public abstract class PathTemplateFilter {
    private static final String PATH_TEMPLATE_REGEX = "\\s*([\\w\\.-]*)\\s*:\\s*(!)?([^!]*)";
    private static final Pattern PATH_TEMPLATE_PATTERN = Pattern.compile("\\s*([\\w\\.-]*)\\s*:\\s*(!)?([^!]*)");
    private static final String WILDCARD = "*";
    private static final PathTemplateFilter NO_OP_FILTER = new PathTemplateFilter(){

        @Override
        FilteredAddress filter(PathAddress address) {
            return new FilteredAddress(){

                @Override
                public boolean isFiltered() {
                    return true;
                }

                @Override
                public boolean matches() {
                    return true;
                }
            };
        }

        @Override
        public boolean hasPathTemplate(String pathTemplateName) {
            return false;
        }
    };

    abstract FilteredAddress filter(PathAddress var1);

    public abstract boolean hasPathTemplate(String var1);

    public static PathTemplateFilter parse(List<String> attributes) throws ParseException {
        if (attributes == null || attributes.isEmpty()) {
            return NO_OP_FILTER;
        }
        Builder builder = null;
        for (String attribute : attributes) {
            for (String attr : PathAddress.split(attribute, ";")) {
                Matcher matcher = PATH_TEMPLATE_PATTERN.matcher(attr);
                if (matcher.matches()) {
                    String pathTemplate = matcher.group(1);
                    if (builder == null) {
                        builder = PathTemplateFilter.create(pathTemplate);
                    } else {
                        builder.and(pathTemplate);
                    }
                    boolean exclusion = matcher.group(2) != null;
                    List<String> expressions = PathAddress.split(matcher.group(3), ",");
                    for (String expression : expressions) {
                        boolean wildcard = WILDCARD.equals(expression);
                        if (exclusion) {
                            if (wildcard) {
                                builder.excludeAll();
                                continue;
                            }
                            builder.exclude(expression);
                            continue;
                        }
                        if (wildcard) {
                            builder.includeAll();
                            continue;
                        }
                        builder.include(expression);
                    }
                    continue;
                }
                throw new ParseException("Filter attribute '" + attribute + "' is not valid.", 0);
            }
        }
        return builder == null ? NO_OP_FILTER : builder.build();
    }

    public static Builder create(String pathTemplate) {
        return new BuilderImpl(pathTemplate);
    }

    public static enum FilterType {
        inclusion,
        exclusion;

    }

    private static class Expression {
        private final String templateName;
        private final String value;
        private final FilterType filterType;

        private Expression(String templateName, String value, FilterType filterType) {
            this.templateName = templateName;
            this.value = value;
            this.filterType = filterType;
        }

        public boolean match(PathAddress address) {
            if (this.value.equals(PathTemplateFilter.WILDCARD)) {
                return true;
            }
            if (this.templateName == null) {
                String path = this.value;
                if (path.charAt(0) != '/') {
                    path = "/" + path;
                }
                return path.equals(address.toString());
            }
            String resolved = address.resolvePathTemplate(this.templateName);
            if (resolved == null) {
                return true;
            }
            String path = this.value;
            if (this.value.charAt(0) == '/') {
                path = this.value.substring(1);
            }
            return resolved.equals(path);
        }

        public boolean resolves(PathAddress address) {
            return address.resolvePathTemplate(this.templateName) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Expression expression = (Expression)o;
            if (!this.value.equals(expression.value)) {
                return false;
            }
            if (this.filterType != expression.filterType) {
                return false;
            }
            return this.templateName.equals(expression.templateName);
        }

        public int hashCode() {
            int result = this.templateName.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + this.filterType.hashCode();
            return result;
        }

        public String toString() {
            return "expression{templateName='" + this.templateName + '\'' + ", value='" + this.value + '\'' + ", filterType=" + (Object)((Object)this.filterType) + '}';
        }
    }

    private static class BuilderImpl
    implements Builder,
    FilterTypeBuilder {
        private String pathTemplate;
        private List<Expression> expressions;

        public BuilderImpl(String pathTemplate) {
            this.pathTemplate = pathTemplate;
            this.expressions = new ArrayList<Expression>();
        }

        @Override
        public FilterTypeBuilder include(String ... includes) {
            if (includes == null) {
                throw new IllegalArgumentException("includes is null");
            }
            this.addExpression(FilterType.inclusion, includes);
            return this;
        }

        @Override
        public FilterTypeBuilder includeAll() {
            this.addExpression(FilterType.inclusion, PathTemplateFilter.WILDCARD);
            return this;
        }

        @Override
        public FilterTypeBuilder excludeAll() {
            this.addExpression(FilterType.exclusion, PathTemplateFilter.WILDCARD);
            return this;
        }

        @Override
        public FilterTypeBuilder exclude(String ... excludes) {
            if (excludes == null) {
                throw new IllegalArgumentException("excludes is null");
            }
            this.addExpression(FilterType.exclusion, excludes);
            return this;
        }

        @Override
        public PathTemplateFilter build() {
            return new SimpleFilter(new ArrayList<Expression>(this.expressions));
        }

        @Override
        public Builder and(String pathTemplate) {
            this.pathTemplate = pathTemplate;
            return this;
        }

        private void addExpression(FilterType filterType, String ... values) {
            for (String value : values) {
                this.expressions.add(new Expression(this.pathTemplate, value, filterType));
            }
        }
    }

    public static interface FilterTypeBuilder {
        public PathTemplateFilter build();

        public Builder and(String var1);
    }

    public static interface Builder {
        public FilterTypeBuilder include(String ... var1);

        public FilterTypeBuilder includeAll();

        public FilterTypeBuilder exclude(String ... var1);

        public FilterTypeBuilder excludeAll();

        public PathTemplateFilter build();

        public Builder and(String var1);
    }

    private static class SimpleFilter
    extends PathTemplateFilter {
        private final List<Expression> expressions;

        public SimpleFilter(List<Expression> expressions) {
            this.expressions = expressions;
        }

        @Override
        FilteredAddress filter(final PathAddress address) {
            return new FilteredAddress(){

                @Override
                public boolean isFiltered() {
                    for (Expression expression : SimpleFilter.this.expressions) {
                        boolean filtered = expression.resolves(address);
                        if (!filtered) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean matches() {
                    boolean overall = true;
                    HashSet<String> matchedTemplates = new HashSet<String>();
                    for (Expression expression : SimpleFilter.this.expressions) {
                        if (matchedTemplates.contains(expression.templateName)) continue;
                        boolean match = expression.match(address);
                        if (match && expression.filterType == FilterType.exclusion && expression.resolves(address)) {
                            return false;
                        }
                        if (expression.filterType == FilterType.exclusion) {
                            overall = true;
                            continue;
                        }
                        if (match && expression.resolves(address)) {
                            matchedTemplates.add(expression.templateName);
                            overall = true;
                            continue;
                        }
                        overall = overall && match;
                    }
                    return overall;
                }
            };
        }

        @Override
        public boolean hasPathTemplate(String pathTemplateName) {
            for (Expression expression : this.expressions) {
                if (!expression.templateName.equals(pathTemplateName)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleFilter that = (SimpleFilter)o;
            return ((Object)this.expressions).equals(that.expressions);
        }

        public int hashCode() {
            return ((Object)this.expressions).hashCode();
        }

        public String toString() {
            return "SimpleFilter{expressions=" + this.expressions + '}';
        }
    }
}

