/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class IsAbleToRestoreFilter
extends UIExtensionAbstractFilter {
    public IsAbleToRestoreFilter() {
        this(null);
    }

    public IsAbleToRestoreFilter(String messageKey) {
        super(messageKey, UIExtensionFilterType.MANDATORY);
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        Node restoreLocationNode;
        if (context == null) {
            return true;
        }
        Node currentNode = (Node)context.get(Node.class.getName());
        if (ConversationState.getCurrent().getIdentity().getUserId().equalsIgnoreCase(WCMCoreUtils.getSuperUser())) {
            return true;
        }
        if (!currentNode.isNodeType("exo:restoreLocation")) {
            return false;
        }
        String restorePath = currentNode.getProperty("exo:restorePath").getString();
        String restoreWorkspace = currentNode.getProperty("exo:restoreWorkspace").getString();
        restorePath = restorePath.substring(0, restorePath.lastIndexOf("/"));
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(restoreWorkspace, WCMCoreUtils.getRepository());
        try {
            restoreLocationNode = (Node)session.getItem(restorePath);
        }
        catch (Exception e) {
            return false;
        }
        return PermissionUtil.canAddNode((Node)restoreLocationNode);
    }

    public void onDeny(Map<String, Object> context) throws Exception {
        this.createUIPopupMessages(context, "UIDocumentInfo.msg.access-denied");
    }
}

