/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.identity.exceptions.NoSuchUserException;
import org.josso.gateway.session.SSOSession;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.service.SSOSessionManager;

public class SSOSecurityDomainInfo {
    private static final Log logger = LogFactory.getLog(SSOSecurityDomainInfo.class);
    private SecurityDomain domain;
    private Properties props;

    public SSOSecurityDomainInfo(SecurityDomain domain) throws MBeanException, RuntimeOperationsException {
        this.domain = domain;
        this.props = new Properties();
        InputStream in = this.getClass().getResourceAsStream("/org/josso/josso.properties");
        try {
            this.props.load(in);
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getVersion() {
        return this.props.getProperty("version");
    }

    public String getFullName() {
        return this.props.getProperty("fullname");
    }

    public String getName() {
        return this.props.getProperty("name");
    }

    public Long getSessionCount() {
        try {
            return new Long(this.domain.getSessionManager().getSessionCount());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new Long(0L);
        }
    }

    public void invalidateAll() {
        try {
            this.domain.getSessionManager().invalidateAll();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void invalidateUserSessions(String username) {
        try {
            SSOSessionManager sm = this.domain.getSessionManager();
            Collection sessions = sm.getUserSessions(username);
            for (SSOSession session : sessions) {
                try {
                    sm.invalidate(session.getId());
                }
                catch (NoSuchSessionException e) {
                    logger.warn((Object)("Alrady invalidated : " + session.getId()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void invalidateSession(String sessionId) {
        try {
            this.domain.getSessionManager().invalidate(sessionId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean userExists(String username) {
        try {
            this.domain.getIdentityManager().userExists(username);
            return true;
        }
        catch (NoSuchUserException e) {
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void checkValidSessions() {
        try {
            this.domain.getSessionManager().checkValidSessions();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Collection listUserSessions(String username) {
        try {
            return this.domain.getSessionManager().getUserSessions(username);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList(0);
        }
    }

    public Collection listSessions() {
        try {
            return this.domain.getSessionManager().getSessions();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList(0);
        }
    }
}

