/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.InputStream;
import java.net.URL;
import javax.naming.InitialContext;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.organization.idm.InfinispanCacheFactory;
import org.exoplatform.services.organization.idm.IntegrationCache;
import org.exoplatform.services.organization.idm.PicketLinkIDMCacheService;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.infinispan.Cache;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picocontainer.Startable;

public class PicketLinkIDMServiceImpl
implements PicketLinkIDMService,
Startable {
    private static Log log = ExoLogger.getLogger(PicketLinkIDMServiceImpl.class);
    public static final String PARAM_CONFIG_OPTION = "config";
    public static final String PARAM_JNDI_NAME_OPTION = "jndiName";
    public static final String PARAM_SKIP_EXPIRATION_STRUCTURE_CACHE_ENTRIES = "skipExpirationOfStructureCacheEntries";
    public static final String PARAM_STALE_CACHE_NODES_LINKS_CLEANER_DELAY = "staleCacheNodesLinksCleanerDelay";
    public static final int DEFAULT_STALE_CACHE_NODES_LINKS_CLEANER_DELAY = 120000;
    public static final String REALM_NAME_OPTION = "portalRealm";
    public static final String CACHE_CONFIG_API_OPTION = "apiCacheConfig";
    public static final String CACHE_CONFIG_STORE_OPTION = "storeCacheConfig";
    private IdentitySessionFactory identitySessionFactory;
    private String config;
    private String realmName = "idm_realm";
    private IdentityConfiguration identityConfiguration;
    private IntegrationCache integrationCache;
    private HibernateService hibernateService;
    private InfinispanCacheFactory infinispanCacheFactory = InfinispanCacheFactory.getInstance();

    private PicketLinkIDMServiceImpl() {
    }

    public PicketLinkIDMServiceImpl(ExoContainerContext exoContainerContext, InitParams initParams, HibernateService hibernateService, ConfigurationManager confManager, PicketLinkIDMCacheService picketLinkIDMCache, InitialContextInitializer dependency) throws Exception {
        ValueParam config = initParams.getValueParam(PARAM_CONFIG_OPTION);
        ValueParam jndiName = initParams.getValueParam(PARAM_JNDI_NAME_OPTION);
        ValueParam canExpireStructureCacheEntriesParam = initParams.getValueParam(PARAM_SKIP_EXPIRATION_STRUCTURE_CACHE_ENTRIES);
        ValueParam staleCacheNodesLinksCleanerDelayParam = initParams.getValueParam(PARAM_STALE_CACHE_NODES_LINKS_CLEANER_DELAY);
        ValueParam realmName = initParams.getValueParam(REALM_NAME_OPTION);
        ValueParam apiCacheConfig = initParams.getValueParam(CACHE_CONFIG_API_OPTION);
        ValueParam storeCacheConfig = initParams.getValueParam(CACHE_CONFIG_STORE_OPTION);
        this.hibernateService = hibernateService;
        if (config == null && jndiName == null) {
            throw new IllegalStateException("Either 'config' or 'jndiName' parameter must be specified");
        }
        if (realmName != null) {
            this.realmName = realmName.getValue();
        }
        long staleCacheNodesLinksCleanerDelay = staleCacheNodesLinksCleanerDelayParam == null ? 120000L : Long.parseLong(staleCacheNodesLinksCleanerDelayParam.getValue());
        boolean skipExpirationOfStructureCacheEntries = canExpireStructureCacheEntriesParam != null && "true".equals(canExpireStructureCacheEntriesParam.getValue());
        this.infinispanCacheFactory.setSkipExpirationOfStructureCacheEntries(skipExpirationOfStructureCacheEntries);
        if (config != null) {
            Cache cache;
            InputStream configStream;
            this.config = config.getValue();
            URL configURL = confManager.getURL(this.config);
            if (configURL == null) {
                throw new IllegalStateException("Cannot fine resource: " + this.config);
            }
            IdentityConfigurationMetaData configMD = JAXB2IdentityConfiguration.createConfigurationMetaData((InputStream)confManager.getInputStream(this.config));
            this.identityConfiguration = new IdentityConfigurationImpl().configure(configMD);
            this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)hibernateService.getSessionFactory(), "hibernateSessionFactory");
            if (apiCacheConfig != null) {
                configStream = confManager.getInputStream(apiCacheConfig.getValue());
                if (configStream == null) {
                    throw new IllegalArgumentException("Infinispan configuration InputStream is null");
                }
                cache = this.infinispanCacheFactory.createInfinispanCache(configStream, exoContainerContext.getPortalContainerName(), "api");
                configStream.close();
                APICacheProvider apiCacheProvider = this.infinispanCacheFactory.createAPICacheProvider(staleCacheNodesLinksCleanerDelay, cache);
                picketLinkIDMCache.register(apiCacheProvider);
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)apiCacheProvider, "apiCacheProvider");
                this.integrationCache = this.infinispanCacheFactory.createIntegrationCache(cache);
                picketLinkIDMCache.register(this.integrationCache);
            }
            if (storeCacheConfig != null) {
                configStream = confManager.getInputStream(storeCacheConfig.getValue());
                if (configStream == null) {
                    throw new IllegalArgumentException("Infinispan configuration InputStream is null");
                }
                cache = this.infinispanCacheFactory.createInfinispanCache(configStream, exoContainerContext.getPortalContainerName(), "store");
                configStream.close();
                IdentityStoreCacheProvider storeCacheProvider = this.infinispanCacheFactory.createStoreCacheProvider(staleCacheNodesLinksCleanerDelay, cache);
                picketLinkIDMCache.register(storeCacheProvider);
                this.identityConfiguration.getIdentityConfigurationRegistry().register((Object)storeCacheProvider, "storeCacheProvider");
            }
        } else {
            this.identitySessionFactory = (IdentitySessionFactory)new InitialContext().lookup(jndiName.getValue());
        }
    }

    public void start() {
        if (this.identitySessionFactory == null) {
            try {
                this.identitySessionFactory = this.identityConfiguration.buildIdentitySessionFactory();
            }
            catch (IdentityConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void stop() {
    }

    @Override
    public IdentitySessionFactory getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    @Override
    public IdentitySession getIdentitySession() throws Exception {
        return this.getIdentitySessionFactory().getCurrentIdentitySession(this.realmName);
    }

    @Override
    public IdentitySession getIdentitySession(String realm) throws Exception {
        if (realm == null) {
            throw new IllegalArgumentException("Realm name cannot be null");
        }
        return this.getIdentitySessionFactory().getCurrentIdentitySession(realm);
    }

    public IntegrationCache getIntegrationCache() {
        return this.integrationCache;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public HibernateService getHibernateService() {
        return this.hibernateService;
    }
}

