/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.factories;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.ehcache.store.compound.factories.RegionSet;

final class FileAllocationTree
extends RegionSet {
    private long fileSize;
    private RandomAccessFile data;

    public FileAllocationTree(long maxSize, RandomAccessFile file) {
        super(maxSize);
    }

    public synchronized RegionSet.Region alloc(long size) {
        RegionSet.Region r = this.find(size);
        this.mark(r);
        return r;
    }

    public synchronized void mark(RegionSet.Region r) {
        RegionSet.Region current = this.find(r);
        if (current == null) {
            throw new IllegalArgumentException();
        }
        RegionSet.Region newRange = (current = this.remove(current)).remove(r);
        if (newRange != null) {
            this.insert(current);
            this.insert(newRange);
        } else if (!current.isNull()) {
            this.insert(current);
        }
        this.checkGrow(r);
    }

    public synchronized void free(RegionSet.Region r) {
        RegionSet.Region prev = this.find(new RegionSet.Region(r.start() - 1L));
        if (prev != null) {
            prev = this.remove(prev);
            prev.merge(r);
            RegionSet.Region next = this.remove(new RegionSet.Region(r.end() + 1L));
            if (next != null) {
                prev.merge(next);
            }
            this.insert(prev);
            this.checkShrink(prev);
            return;
        }
        RegionSet.Region next = this.find(new RegionSet.Region(r.end() + 1L));
        if (next != null) {
            next = this.remove(next);
            next.merge(r);
            this.insert(next);
            this.checkShrink(next);
            return;
        }
        this.insert(r);
        this.checkShrink(r);
    }

    public synchronized void clear() {
        super.clear();
    }

    private void checkGrow(RegionSet.Region alloc) {
        if (alloc.end() >= this.fileSize) {
            this.fileSize = alloc.end() + 1L;
            this.grow(this.fileSize);
        }
    }

    private void checkShrink(RegionSet.Region free) {
        if (free.end() >= this.fileSize - 1L) {
            this.fileSize = free.start();
            this.shrink(this.fileSize);
        }
    }

    private void grow(long size) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrink(long size) {
        if (this.data == null) {
            return;
        }
        RandomAccessFile randomAccessFile = this.data;
        synchronized (randomAccessFile) {
            try {
                this.data.setLength(size);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public synchronized long getFileSize() {
        return this.fileSize;
    }
}

