/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.chromattic.SynchronizationListener;
import org.exoplatform.commons.chromattic.SynchronizationStatus;
import org.exoplatform.services.jcr.core.ManageableRepository;

abstract class AbstractContext
implements SessionContext {
    ChromatticSession session;
    private Map<String, Object> attributes;
    final ChromatticLifeCycle lifeCycle;
    private HashSet<SynchronizationListener> listeners;

    AbstractContext(ChromatticLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        this.session = null;
        this.listeners = null;
    }

    @Override
    public final ChromatticSession getSession() {
        if (this.session == null) {
            this.session = this.lifeCycle.realChromattic.openSession();
        }
        return this.session;
    }

    @Override
    public final Object getAttachment(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    @Override
    public final void setAttachment(String name, Object attribute) {
        if (attribute != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, attribute);
        } else if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public abstract Session doLogin() throws RepositoryException;

    protected final Session openSession() throws RepositoryException {
        ManageableRepository repo = this.lifeCycle.manager.repositoryService.getCurrentRepository();
        return repo.getSystemSession(this.lifeCycle.getWorkspaceName());
    }

    public void close(boolean save) {
        if (this.listeners != null) {
            for (SynchronizationListener listener : this.listeners) {
                try {
                    listener.beforeSynchronization();
                }
                catch (Exception e) {}
            }
        }
        if (this.session != null) {
            if (save) {
                this.session.save();
            }
            this.session.close();
        }
        if (this.listeners != null) {
            SynchronizationStatus status = save ? SynchronizationStatus.SAVED : SynchronizationStatus.DISCARDED;
            for (SynchronizationListener listener : this.listeners) {
                try {
                    listener.afterSynchronization(status);
                }
                catch (Exception e) {}
            }
        }
        this.lifeCycle.currentContext.set(null);
        this.lifeCycle.onCloseSession(this);
    }

    @Override
    public final void addSynchronizationListener(SynchronizationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }
}

