/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.Abbreviator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;

public class AbbreviatorTest
extends TestCase {
    public final void testOne() {
        Abbreviator a = new Abbreviator(Collections.singleton("test:///foo/bar"), "/");
        AbbreviatorTest.assertEquals((String)"bar", (String)a.unambiguousAbbreviationFor("test:///foo/bar"));
    }

    public final void testAbbreviator() {
        Abbreviator a = new Abbreviator(new HashSet<String>(Arrays.asList("/a/b/c", "/a/d/e", "/a/d/f", "/a/g/h/c", "/h/i", "/h/j/", "/", "/c", "/d", "x", "")), "/");
        AbbreviatorTest.assertEquals((String)"b/c", (String)a.unambiguousAbbreviationFor("/a/b/c"));
        AbbreviatorTest.assertEquals((String)"h/c", (String)a.unambiguousAbbreviationFor("/a/g/h/c"));
        AbbreviatorTest.assertEquals((String)"e", (String)a.unambiguousAbbreviationFor("/a/d/e"));
        AbbreviatorTest.assertEquals((String)"f", (String)a.unambiguousAbbreviationFor("/a/d/f"));
        AbbreviatorTest.assertEquals((String)"i", (String)a.unambiguousAbbreviationFor("/h/i"));
        AbbreviatorTest.assertEquals((String)"j/", (String)a.unambiguousAbbreviationFor("/h/j/"));
        AbbreviatorTest.assertEquals((String)"/", (String)a.unambiguousAbbreviationFor("/"));
        AbbreviatorTest.assertEquals((String)"/c", (String)a.unambiguousAbbreviationFor("/c"));
        AbbreviatorTest.assertEquals((String)"d", (String)a.unambiguousAbbreviationFor("/d"));
        AbbreviatorTest.assertEquals((String)"x", (String)a.unambiguousAbbreviationFor("x"));
        AbbreviatorTest.assertEquals((String)"", (String)a.unambiguousAbbreviationFor(""));
        AbbreviatorTest.assertEquals((String)"/notpresent", (String)a.unambiguousAbbreviationFor("/notpresent"));
    }

    public final void testSetContainsSuffixOfOtherMember() {
        Abbreviator a = new Abbreviator(new HashSet<String>(Arrays.asList("foo:bar/z", "foo:foo:baz/z", "foo:baz/z", "foo:bar:far/z")), ":");
        AbbreviatorTest.assertEquals((String)"bar/z", (String)a.unambiguousAbbreviationFor("foo:bar/z"));
        AbbreviatorTest.assertEquals((String)"foo:baz/z", (String)a.unambiguousAbbreviationFor("foo:baz/z"));
        AbbreviatorTest.assertEquals((String)"foo:foo:baz/z", (String)a.unambiguousAbbreviationFor("foo:foo:baz/z"));
        AbbreviatorTest.assertEquals((String)"far/z", (String)a.unambiguousAbbreviationFor("foo:bar:far/z"));
    }
}

