/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.mdat;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaDataBoxWithSamples
extends AbstractBox {
    private List<IsoBufferWrapper> samples;

    public MediaDataBoxWithSamples(List<IsoBufferWrapper> samples) {
        super(IsoFile.fourCCtoBytes("mdat"));
        this.samples = samples;
    }

    @Override
    protected long getContentSize() {
        long size = 0L;
        for (IsoBufferWrapper sample : this.samples) {
            size += sample.size();
        }
        return 0L;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (IsoBufferWrapper ibw : this.samples) {
            while (ibw.remaining() >= 1024L) {
                os.write(ibw.read(1024));
            }
            while (ibw.remaining() > 0L) {
                os.write(ibw.readByte());
            }
        }
    }

    public List<IsoBufferWrapper> getSamples() {
        return this.samples;
    }
}

