/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import com.coremedia.iso.boxes.UserDataBox;
import com.coremedia.iso.boxes.odf.OmaDrmCommonHeadersBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmaDrmDiscreteHeadersBox
extends FullContainerBox {
    public static final String TYPE = "odhe";
    private String contentType;

    public OmaDrmDiscreteHeadersBox() {
        super(TYPE);
    }

    @Override
    public <T extends Box> List<T> getBoxes(Class<T> clazz) {
        ArrayList<T> boxesToBeReturned = new ArrayList<T>();
        for (Box boxe : this.boxes) {
            if (!clazz.isInstance(boxe)) continue;
            boxesToBeReturned.add(clazz.cast(boxe));
        }
        return boxesToBeReturned;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    protected long getContentSize() {
        long size = 0L;
        for (Box boxe : this.boxes) {
            size += boxe.getSize();
        }
        return size + 1L + (long)OmaDrmDiscreteHeadersBox.utf8StringLengthInBytes(this.contentType);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        Box box;
        this.parseHeader(in, size);
        int contentTypeLength = in.readUInt8();
        this.contentType = new String(in.read(contentTypeLength), "UTF-8");
        for (long remainingContentSize = size - 4L - 1L - (long)contentTypeLength; remainingContentSize > 0L; remainingContentSize -= box.getSize()) {
            box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            this.boxes.add(box);
        }
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        long sp = isos.getStreamPosition();
        isos.writeUInt8(OmaDrmDiscreteHeadersBox.utf8StringLengthInBytes(this.contentType));
        isos.writeStringNoTerm(this.contentType);
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
        assert (isos.getStreamPosition() - sp == this.getContentSize());
    }

    public OmaDrmCommonHeadersBox getOmaDrmCommonHeadersBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof OmaDrmCommonHeadersBox)) continue;
            return (OmaDrmCommonHeadersBox)box;
        }
        return null;
    }

    public UserDataBox getUserDataBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof UserDataBox)) continue;
            return (UserDataBox)box;
        }
        return null;
    }
}

