/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class DeleteShareJob
implements Job,
InterruptableJob {
    private static Log log = ExoLogger.getLogger((String)"cs.service.job");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info((Object)"Start un-sharing job");
        try {
            ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
            OrganizationService oService = (OrganizationService)PortalContainer.getInstance().getComponentInstance(OrganizationService.class);
            CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String username = jobDataMap.getString("userName");
            String calendarId = jobDataMap.getString("calendarId");
            ArrayList unSharedGroups = (ArrayList)jobDataMap.get((Object)"removedUsers");
            Calendar cal = calendarService.getUserCalendar(username, calendarId);
            String calendarName = cal.getName();
            String startMessage = Utils.buildMessageToSend("startUnShare", calendarName, unSharedGroups, oService);
            String stopMessage = Utils.buildMessageToSend("finishUnShare", calendarName, unSharedGroups, oService);
            continuation.sendMessage(username, "/eXo/Application/Calendar/notifyShareCalendar", (Object)startMessage);
            List<Object> viewUsers = new ArrayList();
            if (cal.getViewPermission() != null) {
                viewUsers = Arrays.asList(cal.getViewPermission());
            }
            for (String group : unSharedGroups) {
                for (User user : oService.getUserHandler().findUsersByGroup(group).getAll()) {
                    Object[] groups;
                    String userId = user.getUserName();
                    boolean deleteShared = true;
                    if (viewUsers.contains(userId)) continue;
                    for (Object object : groups = oService.getGroupHandler().findGroupsOfUser(userId).toArray()) {
                        if (!Arrays.asList(cal.getViewPermission()).contains(((Group)object).getId())) continue;
                        deleteShared = false;
                        break;
                    }
                    if (!deleteShared) continue;
                    calendarService.removeSharedCalendar(userId, calendarId);
                }
            }
            continuation.sendMessage(username, "/eXo/Application/Calendar/notifyShareCalendar", (Object)stopMessage);
            log.info((Object)"Finish un-sharing job");
        }
        catch (Exception e) {
            log.debug((Object)"Error while un-sharing calendar for groups", (Throwable)e);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
    }
}

