/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.Synchronization;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.QueryFunction;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class StorageUtils {
    public static final String ASTERISK_STR = "*";
    public static final String PERCENT_STR = "%";
    public static final char ASTERISK_CHAR = '*';
    public static final String SPACE_STR = " ";
    public static final String EMPTY_STR = "";
    public static final String SLASH_STR = "/";
    public static final String SOC_ACTIVITY_INFO = "soc:activityInfo";
    public static final String SOC_PREFIX = "soc:";
    private static List<String> userInPlatformGroups = null;
    private static final Log LOG = ExoLogger.getLogger((String)StorageUtils.class.getName());

    public static void applyFilter(WhereExpression whereExpression, ProfileFilter profileFilter) {
        String inputName = profileFilter.getName().replace(ASTERISK_STR, PERCENT_STR);
        StorageUtils.processUsernameSearchPattern(inputName.trim());
        String position = StorageUtils.addPositionSearchPattern(profileFilter.getPosition().trim()).replace(ASTERISK_STR, PERCENT_STR);
        inputName = inputName.isEmpty() ? ASTERISK_STR : inputName;
        String nameForSearch = inputName.replace(ASTERISK_STR, SPACE_STR);
        char firstChar = profileFilter.getFirstCharacterOfName();
        String skills = profileFilter.getSkills();
        if (firstChar != '\u0000') {
            whereExpression.and().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.lastName), String.valueOf(firstChar).toLowerCase() + PERCENT_STR);
        } else if (nameForSearch.trim().length() != 0) {
            whereExpression.and().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.fullName), PERCENT_STR + nameForSearch.toLowerCase() + PERCENT_STR);
        }
        if (position.length() != 0) {
            whereExpression.and().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.position), PERCENT_STR + position.toLowerCase() + PERCENT_STR);
        }
        if (skills.length() != 0) {
            whereExpression.and().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.skills), PERCENT_STR + skills.toLowerCase() + PERCENT_STR);
        }
        if (profileFilter.getAll().length() != 0) {
            String value = profileFilter.getAll();
            whereExpression.and().startGroup().contains(ProfileEntity.fullName, value.toLowerCase()).or().contains(ProfileEntity.firstName, value.toLowerCase()).or().contains(ProfileEntity.lastName, value.toLowerCase()).or().contains(ProfileEntity.position, value.toLowerCase()).or().contains(ProfileEntity.skills, value.toLowerCase()).or().contains(ProfileEntity.positions, value.toLowerCase()).or().contains(ProfileEntity.organizations, value.toLowerCase()).or().contains(ProfileEntity.jobsDescription, value.toLowerCase()).endGroup();
        }
    }

    public static void applyExcludes(WhereExpression whereExpression, List<Identity> excludedIdentityList) {
        if (excludedIdentityList != null & excludedIdentityList.size() > 0) {
            for (Identity identity : excludedIdentityList) {
                whereExpression.and().not().equals(ProfileEntity.parentId, identity.getId());
            }
        }
    }

    public static void applyWhereFromIdentity(WhereExpression whereExpression, List<Identity> identities) {
        whereExpression.startGroup();
        for (int i = 0; identities.size() > i; ++i) {
            Identity current = identities.get(i);
            whereExpression.equals(JCRProperties.id, current.getProfile().getId());
            if (i + 1 >= identities.size()) continue;
            whereExpression.or();
        }
        whereExpression.endGroup();
    }

    public static String processUsernameSearchPattern(String userName) {
        String modifiedUserName = userName;
        if (modifiedUserName.length() > 0) {
            modifiedUserName = EMPTY_STR.equals(modifiedUserName) || modifiedUserName.length() == 0 ? ASTERISK_STR : modifiedUserName;
            modifiedUserName = modifiedUserName.charAt(0) != '*' ? ASTERISK_STR + modifiedUserName : modifiedUserName;
            modifiedUserName = modifiedUserName.charAt(modifiedUserName.length() - 1) != '*' ? (modifiedUserName = modifiedUserName + ASTERISK_STR) : modifiedUserName;
            modifiedUserName = modifiedUserName.indexOf(ASTERISK_STR) >= 0 ? modifiedUserName.replace(ASTERISK_STR, ".*") : modifiedUserName;
            modifiedUserName = modifiedUserName.indexOf(PERCENT_STR) >= 0 ? modifiedUserName.replace(PERCENT_STR, ".*") : modifiedUserName;
            Pattern.compile(modifiedUserName);
        }
        return userName;
    }

    public static String addPositionSearchPattern(String position) {
        if (position.length() != 0) {
            if (position.indexOf(ASTERISK_STR) == -1) {
                return ASTERISK_STR + position + ASTERISK_STR;
            }
            return position;
        }
        return EMPTY_STR;
    }

    public static String encodeUrl(String path) {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        ChromatticSession chromatticSession = lifeCycle.getSession();
        StringBuilder encodedUrl = new StringBuilder();
        encodedUrl = encodedUrl.append(SLASH_STR).append(container.getRestContextName()).append("/jcr/").append(lifeCycle.getRepositoryName()).append(SLASH_STR).append(chromatticSession.getJCRSession().getWorkspace().getName()).append(path.replaceAll(PERCENT_STR, "%25"));
        return encodedUrl.toString();
    }

    public static boolean isUserActivated(String remoteId) throws IdentityStorageException {
        try {
            if (userInPlatformGroups == null) {
                OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
                ListAccess listAccess = orgService.getUserHandler().findUsersByGroupId("/platform/users");
                int offset = 0;
                int limit = 100;
                int totalSize = listAccess.getSize();
                userInPlatformGroups = new ArrayList<String>();
                limit = Math.min(limit, totalSize);
                int loaded = 0;
                loaded = StorageUtils.loadUserRange((ListAccess<User>)listAccess, offset, limit, userInPlatformGroups);
                if (limit != totalSize) {
                    while (loaded == 100) {
                        if ((offset += limit) + limit > totalSize) {
                            limit = totalSize - offset;
                        }
                        loaded = StorageUtils.loadUserRange((ListAccess<User>)listAccess, offset, limit, userInPlatformGroups);
                    }
                }
            }
            return userInPlatformGroups.contains(remoteId);
        }
        catch (Exception e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_GET_IDENTITY_BY_PROFILE_FILTER, e.getMessage());
        }
    }

    private static int loadUserRange(ListAccess<User> listAccess, int offset, int limit, List<String> userList) throws Exception {
        User[] gotList;
        for (User item : gotList = (User[])listAccess.load(offset, limit)) {
            userList.add(item.getUserName());
        }
        return gotList.length;
    }

    public static void clearUsersPlatformGroup() {
        userInPlatformGroups = null;
    }

    public static List<String> processUnifiedSearchCondition(String searchCondition) {
        String[] spaceConditions = searchCondition.split(SPACE_STR);
        ArrayList<String> result = new ArrayList<String>(spaceConditions.length);
        StringBuffer searchConditionBuffer = null;
        for (String conditionValue : spaceConditions) {
            searchConditionBuffer = new StringBuffer();
            if (!conditionValue.contains(ASTERISK_STR) && !conditionValue.contains(PERCENT_STR)) {
                searchConditionBuffer.append(ASTERISK_STR).append(conditionValue).append(ASTERISK_STR);
            } else {
                conditionValue = conditionValue.replace(ASTERISK_STR, PERCENT_STR);
                searchConditionBuffer.append(PERCENT_STR).append(conditionValue).append(PERCENT_STR);
            }
            result.add(searchConditionBuffer.toString());
        }
        return result;
    }

    public static <T> int getCommonItemNumber(List<T> m, List<T> n) {
        if (m == null || n == null) {
            return 0;
        }
        ArrayList<T> copy = new ArrayList<T>(m);
        copy.removeAll(n);
        return m.size() - copy.size();
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map, final boolean asc) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                if (asc) {
                    return ((Comparable)o1.getValue()).compareTo(o2.getValue());
                }
                return ((Comparable)o1.getValue()).compareTo(o2.getValue()) / -1;
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> List<T> subList(List<T> list, int startIndex, int toIndex) {
        int totalSize = list.size();
        if (startIndex >= totalSize) {
            return Collections.emptyList();
        }
        if (toIndex >= totalSize) {
            toIndex = totalSize;
        }
        return list.subList(startIndex, toIndex);
    }

    public static String[] sub(String[] l1, String[] l2) {
        if (l1 == null) {
            return new String[0];
        }
        if (l2 == null) {
            return l1;
        }
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(l1));
        l.removeAll(Arrays.asList(l2));
        return l.toArray(new String[0]);
    }

    public static boolean persist() {
        try {
            ChromatticSession chromatticSession = AbstractStorage.lifecycleLookup().getSession();
            if (chromatticSession.getJCRSession().hasPendingChanges()) {
                chromatticSession.save();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean persistJCR(boolean beginRequest) {
        try {
            AbstractStorage.lifecycleLookup().closeContext(true);
            if (beginRequest) {
                AbstractStorage.lifecycleLookup().openContext();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean endRequest() {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
            Synchronization synchronization = manager.getSynchronization();
            if (synchronization != null) {
                synchronization.setSaveOnClose(true);
                manager.endRequest(true);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public <T> List<T> intersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public <T> T[] intersection(T[] array1, T[] array2) {
        List<T> got = this.intersection(Arrays.asList(array1), Arrays.asList(array2));
        return got.toArray();
    }

    public static <T> List<T> sub(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>(a);
        Iterator<T> it = b.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }
}

