/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.friendly.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.friendly.impl.FriendlyConfig;
import org.exoplatform.services.wcm.friendly.impl.FriendlyPlugin;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="friendly"), @Property(key="type", value="content")})
@ManagedDescription(value="Friendly service")
@RESTEndpoint(path="friendlyservice")
public class FriendlyServiceImpl
implements FriendlyService {
    private String servletName = "content";
    private boolean isEnabled = false;
    private Map<String, String> friendlies = new LinkedHashMap<String, String>(5);
    private Map<String, String> unfriendlies = new LinkedHashMap<String, String>(5);
    private static final Log LOG = ExoLogger.getLogger((String)FriendlyServiceImpl.class.getName());

    public FriendlyServiceImpl(InitParams initParams) {
        if (initParams != null) {
            this.init(initParams);
        }
    }

    private void init(InitParams initParams) {
        ObjectParameter objectParam;
        ValueParam enabled = initParams.getValueParam("enabled");
        ValueParam servletName = initParams.getValueParam("servletName");
        if (enabled != null && "true".equals(enabled.getValue())) {
            this.isEnabled = true;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("isEnabled:" + this.isEnabled));
        }
        if (servletName != null) {
            this.servletName = servletName.getValue();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("servletName:" + this.servletName));
        }
        if ((objectParam = initParams.getObjectParam("friendlies.configuration")) != null) {
            FriendlyConfig config = (FriendlyConfig)objectParam.getObject();
            for (FriendlyConfig.Friendly friendly : config.getFriendlies()) {
                this.addFriendly(friendly.getFriendlyUri(), friendly.getUnfriendlyUri());
            }
        }
    }

    @Override
    public void addConfiguration(FriendlyPlugin plugin) {
        this.init(plugin.getInitParams());
    }

    @Override
    @Managed
    @ManagedDescription(value="Is the service enabled ?")
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Managed
    @ManagedDescription(value="Is the service enabled ?")
    public void setEnabled(@ManagedDescription(value="Enable/Disable this service ?") @ManagedName(value="isEnabled") boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    @Managed
    @ManagedDescription(value="The servlet name referenced in this service")
    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    @Override
    @Managed
    @ManagedDescription(value="Add a new friendly in the list")
    public void addFriendly(@ManagedDescription(value="The friendly Uri") @ManagedName(value="friendlyUri") String friendlyUri, @ManagedDescription(value="The unfriendly Uri") @ManagedName(value="unfriendlyUri") String unfriendlyUri) {
        if (!this.friendlies.containsKey(friendlyUri)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("addFriendly::" + friendlyUri + "::" + unfriendlyUri + "::"));
            }
            this.friendlies.put(friendlyUri, unfriendlyUri);
            this.unfriendlies.put(unfriendlyUri, friendlyUri);
        }
    }

    @Override
    public String getFriendlyUri(String unfriendlyUri) {
        if (!this.isEnabled) {
            return unfriendlyUri;
        }
        for (String unf : this.unfriendlies.keySet()) {
            if (!unfriendlyUri.contains(unf)) continue;
            String fr = this.unfriendlies.get(unf);
            return unfriendlyUri.replace(unf, "/" + this.getServletName() + "/" + fr);
        }
        return unfriendlyUri;
    }

    @Override
    public String getUnfriendlyUri(String friendlyUri) {
        int end;
        if (!this.isEnabled) {
            return friendlyUri;
        }
        String friendly = "/" + this.getServletName() + "/";
        int start = friendlyUri.indexOf(friendly) + friendly.length();
        String furi = friendlyUri.substring(start, start + (end = friendlyUri.substring(start).indexOf("/")));
        if (this.friendlies.containsKey(furi)) {
            String unf = this.friendlies.get(furi);
            String target = unf + friendlyUri.substring(start + end);
            return target;
        }
        return friendlyUri;
    }

    @Override
    @Managed
    @ManagedDescription(value="Remove a friendly in the list")
    public void removeFriendly(@ManagedDescription(value="The friendly Uri") @ManagedName(value="friendlyUri") String friendlyUri) {
        if (this.friendlies.containsKey(friendlyUri)) {
            String unf = this.friendlies.get(friendlyUri);
            this.friendlies.remove(friendlyUri);
            this.unfriendlies.remove(unf);
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="The list of registered friendlies")
    public Map<String, String> getFriendlies() {
        return this.friendlies;
    }
}

