/*
 * Decompiled with CFR 0.152.
 */
package org.josso.selfservices.password.lostpassword;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.Credential;
import org.josso.auth.CredentialProvider;
import org.josso.auth.exceptions.AuthenticationFailureException;
import org.josso.gateway.SSOException;
import org.josso.gateway.identity.SSOUser;
import org.josso.gateway.identity.exceptions.SSOIdentityException;
import org.josso.gateway.identity.service.SSOIdentityManager;
import org.josso.selfservices.ChallengeResponseCredential;
import org.josso.selfservices.ProcessRequest;
import org.josso.selfservices.ProcessResponse;
import org.josso.selfservices.ProcessState;
import org.josso.selfservices.annotations.Action;
import org.josso.selfservices.annotations.Extension;
import org.josso.selfservices.password.BasePasswordManagementProcess;
import org.josso.selfservices.password.PasswordDistributor;
import org.josso.selfservices.password.PasswordGenerator;
import org.josso.selfservices.password.PasswordManagementException;
import org.josso.selfservices.password.PasswordManagementProcess;
import org.josso.selfservices.password.lostpassword.Constants;
import org.josso.selfservices.password.lostpassword.LostPasswordProcessState;
import org.josso.selfservices.password.lostpassword.LostPasswordUrlProvider;
import org.josso.util.id.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLostPasswordProcess
extends BasePasswordManagementProcess
implements Constants {
    private static final Log log = LogFactory.getLog(AbstractLostPasswordProcess.class);
    private CredentialProvider credentialProvider;
    private PasswordDistributor distributor;
    private PasswordGenerator generator;
    private SSOIdentityManager identityManager;
    private IdGenerator idGenerator;
    @Extension(value="urlProvider")
    private LostPasswordUrlProvider urlProvider;

    @Override
    public PasswordManagementProcess createNewProcess(String id) throws SSOException {
        AbstractLostPasswordProcess newProcess = (AbstractLostPasswordProcess)super.createNewProcess(id);
        newProcess.setCredentialProvider(this.credentialProvider);
        newProcess.setIdentityManager(this.identityManager);
        newProcess.setPasswordDistributor(this.distributor);
        newProcess.setPasswordGenerator(this.generator);
        newProcess.setIdGenerator(this.idGenerator);
        return newProcess;
    }

    @Override
    protected ProcessState doMakeState(String id) {
        return new LostPasswordProcessState(id);
    }

    @Override
    public ProcessResponse start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting lost password process .. .");
        }
        super.start();
        assert (this.identityManager != null) : "No Identity Manager Configured";
        assert (this.credentialProvider != null) : "No Credential Provider Configured";
        assert (this.distributor != null) : "No Password Distributor Configured";
        assert (this.generator != null) : "No Password Generator Configured";
        assert (this.idGenerator != null) : "No Password Assertion Generator Configured";
        this.getLostPasswordState().setPasswordConfirmUrl(null);
        this.getLostPasswordState().setAssertionId(null);
        this.getLostPasswordState().setChallenges(new HashSet<ChallengeResponseCredential>());
        ChallengeResponseCredential[] challenges = this.createInitilaChallenges();
        ProcessResponse response = this.createResponse("requestChallenges");
        response.setAttribute("challenges", challenges);
        this.storeAllChallenges(challenges);
        return response;
    }

    @Override
    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping lost password process .. .");
        }
        super.stop();
    }

    @Action(fromSteps={"requestChallenges", "requestAdditionalChallenges"})
    public ProcessResponse processChallenges(ProcessRequest request) {
        try {
            ChallengeResponseCredential[] c = (ChallengeResponseCredential[])request.getAttribute("challenges");
            if (c == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No challenges received!");
                }
                return this.createFinalResponse("authError");
            }
            this.storeAllChallenges(c);
            Set<ChallengeResponseCredential> challenges = this.retrieveAllChallenges();
            ChallengeResponseCredential[] additionalChallenges = this.createAdditionalChallenges(challenges);
            if (additionalChallenges != null && additionalChallenges.length > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Requesting additional challengis");
                }
                ProcessResponse response = this.createResponse("requestAdditionalChallenges");
                response.setAttribute("challenges", additionalChallenges);
                this.storeAllChallenges(additionalChallenges);
                return response;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting password reset");
            }
            SSOUser user = this.authenticate(challenges);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + user.getName() + " authenticated"));
            }
            String clearPassword = this.createNewPassword(user, challenges);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Password created for " + user.getName()));
            }
            Credential password = this.credentialProvider.newEncodedCredential("password", clearPassword);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Password encoded for " + user.getName()));
            }
            this.getLostPasswordState().setUser(user);
            this.getLostPasswordState().setNewPasswordCredential(password);
            String passwordAssertionId = this.generateAssertionId(user);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Password Assertion ID [" + passwordAssertionId + "] generated for " + user.getName()));
            }
            this.getLostPasswordState().setAssertionId(passwordAssertionId);
            this.getLostPasswordState().setPasswordConfirmUrl(this.urlProvider.provideResetUrl(passwordAssertionId));
            this.distribute(user, clearPassword);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Password distributed " + user.getName()));
            }
            ProcessResponse response = this.createResponse("confirmPassword");
            ChallengeResponseCredential[] confirmationChallenges = this.createConfirmationChallenges();
            if (confirmationChallenges != null && confirmationChallenges.length > 0) {
                this.storeAllChallenges(confirmationChallenges);
                response.setAttribute("challenges", confirmationChallenges);
            }
            return response;
        }
        catch (AuthenticationFailureException e) {
            log.error((Object)("Authentication error " + e.getMessage()), (Throwable)e);
            ProcessResponse response = this.createFinalResponse("authError");
            response.setAttribute("error", e);
            return response;
        }
        catch (Exception e) {
            log.error((Object)("Fatal error error " + e.getMessage()), (Throwable)e);
            ProcessResponse response = this.createFinalResponse("fatalError");
            response.setAttribute("error", e);
            return response;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Action(fromSteps={"confirmPassword", "requestAdditionalConfirmationChallenges"})
    public ProcessResponse requestPasswordConfirmation(ProcessRequest request) throws PasswordManagementException {
        ChallengeResponseCredential[] c = (ChallengeResponseCredential[])request.getAttribute("challenges");
        this.storeAllChallenges(c);
        ChallengeResponseCredential[] additionalChallenges = this.createAdditionalConfirmationChallenges(this.retrieveAllChallenges());
        if (additionalChallenges != null && additionalChallenges.length > 0) {
            ProcessResponse response = this.createFinalResponse("requestAdditionalConfirmationChallenges");
            response.setAttribute("challenges", additionalChallenges);
            this.storeAllChallenges(additionalChallenges);
            return response;
        }
        Set<ChallengeResponseCredential> challenges = this.retrieveAllChallenges();
        if (challenges != null && challenges.size() > 0) {
            try {
                this.authenticateConfirmation();
                SSOUser user = this.getLostPasswordState().getUser();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Password confirmed for " + user.getName()));
                }
                Credential password = this.getLostPasswordState().getNewPasswordCredential();
                this.updateAccount(user, password);
                if (!log.isDebugEnabled()) return this.createFinalResponse("passwordReseted");
                log.debug((Object)("Account updated : " + user.getName()));
                return this.createFinalResponse("passwordReseted");
            }
            catch (AuthenticationFailureException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return this.createFinalResponse("authError");
            }
        } else {
            log.error((Object)"No challenges provided or requested for password confirmation!");
            return this.createFinalResponse("authError");
        }
    }

    @Action(fromSteps={"passwordReseted"})
    public ProcessResponse passwordResetted(ProcessRequest request) {
        this.stop();
        return this.createFinalResponse(null);
    }

    @Action(fromSteps={"fatalError"})
    public ProcessResponse fatalError(ProcessRequest r) {
        this.stop();
        return this.createFinalResponse(null);
    }

    @Action(fromSteps={"authError"})
    public ProcessResponse authError(ProcessRequest r) {
        this.stop();
        return this.createFinalResponse(null);
    }

    protected ChallengeResponseCredential[] createInitilaChallenges() {
        return null;
    }

    protected ChallengeResponseCredential[] createAdditionalChallenges(Set<ChallengeResponseCredential> challenges) {
        return null;
    }

    protected ChallengeResponseCredential[] createConfirmationChallenges() {
        if (this.getChallenge("pwdId") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already created password assertion challenge, value is " + this.getChallenge("pwdId").getValue()));
            }
            return null;
        }
        log.debug((Object)"Creating password assertion challenge");
        ChallengeResponseCredential c = new ChallengeResponseCredential("pwdId", "Password Assertion");
        return new ChallengeResponseCredential[]{c};
    }

    protected ChallengeResponseCredential[] createAdditionalConfirmationChallenges(Set<ChallengeResponseCredential> challenges) {
        return null;
    }

    protected abstract SSOUser authenticate(Set<ChallengeResponseCredential> var1) throws AuthenticationFailureException;

    protected void authenticateConfirmation() throws AuthenticationFailureException {
        ChallengeResponseCredential c = this.getChallenge("pwdId");
        if (c == null || c.getValue() == null) {
            throw new AuthenticationFailureException("No Password Assertion found");
        }
        String assertionId = (String)c.getValue();
        if (!assertionId.equals(this.getPasswordAssertionId())) {
            log.error((Object)("Invalid password assertion  : " + assertionId));
            throw new AuthenticationFailureException("Invalid password assertion : " + this.getPasswordAssertionId());
        }
    }

    protected String createNewPassword(SSOUser user, Set<ChallengeResponseCredential> challenges) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating new password for " + user.getName()));
        }
        return this.generator.generateClearPassword(user, this.retrieveAllChallenges());
    }

    protected void updateAccount(SSOUser user, Credential password) throws PasswordManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating user account for " + user.getName()));
        }
        try {
            this.identityManager.updateAccountPassword(user, password);
        }
        catch (SSOIdentityException e) {
            throw new PasswordManagementException(e.getMessage(), e);
        }
    }

    protected String generateAssertionId(SSOUser user) throws PasswordManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating assertion ID for " + user.getName()));
        }
        return this.idGenerator.generateId();
    }

    protected void distribute(SSOUser user, String password) throws PasswordManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Distributing password for " + user.getName()));
        }
        this.distributor.distributePassword(user, password, this.getLostPasswordState());
    }

    protected SSOUser findUserByUsername(String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for user " + username));
        }
        try {
            return this.identityManager.findUser(username);
        }
        catch (SSOIdentityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected LostPasswordProcessState getLostPasswordState() {
        return (LostPasswordProcessState)this.getState();
    }

    protected ChallengeResponseCredential getChallenge(String id) {
        return this.getChallenge(id, this.retrieveAllChallenges());
    }

    protected ChallengeResponseCredential getChallenge(String id, Set<ChallengeResponseCredential> challenges) {
        for (ChallengeResponseCredential challenge : challenges) {
            if (!challenge.getId().equals(id)) continue;
            return challenge;
        }
        return null;
    }

    protected void storeAllChallenges(ChallengeResponseCredential[] challenges) {
        if (challenges == null) {
            return;
        }
        for (int i = 0; i < challenges.length; ++i) {
            ChallengeResponseCredential challenge = challenges[i];
            this.getLostPasswordState().getChallenges().add(challenge);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Storing challenge : " + challenge.getId() + " [" + challenge.getResponse() + "]"));
        }
    }

    protected void clearChallenges() {
        this.getLostPasswordState().getChallenges().clear();
    }

    protected Set<ChallengeResponseCredential> retrieveAllChallenges() {
        return this.getLostPasswordState().getChallenges();
    }

    public String getPasswordAssertionId() {
        return this.getLostPasswordState().getAssertionId();
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public PasswordDistributor getPasswordDistributor() {
        return this.distributor;
    }

    public void setPasswordDistributor(PasswordDistributor distributor) {
        this.distributor = distributor;
    }

    public PasswordGenerator getPasswordGenerator() {
        return this.generator;
    }

    public void setPasswordGenerator(PasswordGenerator generator) {
        this.generator = generator;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public SSOIdentityManager getIdentityManager() {
        return this.identityManager;
    }

    public void setIdentityManager(SSOIdentityManager identityManager) {
        this.identityManager = identityManager;
    }
}

