/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/action/UIPublicationPanel.gtmpl", events={@EventConfig(listeners={ChangeStateActionListener.class}), @EventConfig(listeners={UIPublicationPanel.ChangeVersionActionListener.class}), @EventConfig(listeners={UIPublicationPanel.PreviewVersionActionListener.class}), @EventConfig(listeners={UIPublicationPanel.RestoreVersionActionListener.class}), @EventConfig(listeners={UIPublicationPanel.SeeAllVersionActionListener.class})})
public class UIPublicationPanel
extends org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPanel {
    private static final Log LOG = LogFactory.getLog((String)UIPublicationPanel.class.getName());

    public void init(Node node) throws Exception {
        String nodeVersionUUID = null;
        super.init(node);
        String currentState = node.getProperty("publication:currentState").getString();
        if (("published".equals(currentState) || "unpublished".equals(currentState)) && !"".equals(nodeVersionUUID = node.getProperty("publication:liveRevision").getString())) {
            Node revision = this.getRevisionByUUID(nodeVersionUUID);
            this.setCurrentRevision(revision);
        }
    }

    public List<LifecyclesConfig.State> getStates(Node cNode) throws Exception {
        ArrayList<LifecyclesConfig.State> states = new ArrayList();
        String lifecycleName = this.getLifeCycle(cNode);
        PublicationManager publicationManagerImpl = (PublicationManager)this.getApplicationComponent(PublicationManager.class);
        LifecyclesConfig.Lifecycle lifecycle = publicationManagerImpl.getLifecycle(lifecycleName);
        states = lifecycle.getStates();
        return states;
    }

    private String getLifeCycle(Node cNode) throws Exception {
        String lifecycleName;
        block2: {
            lifecycleName = null;
            try {
                lifecycleName = cNode.getProperty("publication:lifecycle").getString();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)("Failed to get States for node " + cNode), (Throwable)e);
            }
        }
        return lifecycleName;
    }

    public boolean canReachState(LifecyclesConfig.State state, String remoteUser, NodeImpl node) {
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getApplicationComponent(IdentityRegistry.class);
        Identity currentUser = identityRegistry.getIdentity(remoteUser);
        if (this.isAuthorizedByMembership(state, currentUser)) {
            return true;
        }
        return this.isAuthorizedByRole(state, currentUser, node);
    }

    boolean isAuthorizedByMembership(LifecyclesConfig.State state, Identity currentUser) {
        String membership = state.getMembership();
        ArrayList<String> memberships = new ArrayList<String>();
        if (membership != null) {
            memberships.add(membership);
        }
        if (state.getMemberships() != null) {
            memberships.addAll(state.getMemberships());
        }
        for (String membership_ : memberships) {
            String expectedRole;
            String[] membershipTab = membership_.split(":");
            String expectedGroup = membershipTab[1];
            if (!currentUser.isMemberOf(expectedGroup, expectedRole = membershipTab[0])) continue;
            return true;
        }
        return false;
    }

    boolean isAuthorizedByRole(LifecyclesConfig.State state, Identity currentUser, NodeImpl node) {
        block6: {
            try {
                String role_ = state.getRole();
                ArrayList<String> roles = new ArrayList<String>();
                if (role_ != null) {
                    roles.add(role_);
                }
                if (state.getRoles() != null) {
                    roles.addAll(state.getRoles());
                }
                for (String role : roles) {
                    AccessControlList acl = node.getACL();
                    if (!acl.hasPermissions()) continue;
                    List entries = acl.getPermissionEntries();
                    for (AccessControlEntry accessControlEntry : entries) {
                        String authorizedGroup;
                        String identity = accessControlEntry.getIdentity();
                        if (identity.indexOf(58) <= 0 || !"set_property".equals(accessControlEntry.getPermission()) || !currentUser.isMemberOf(authorizedGroup = identity.split(":")[1], role)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)"Failed to extract node permissions", (Throwable)e);
            }
        }
        return false;
    }

    public static class ChangeStateActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            String state = event.getRequestContext().getRequestParameter("objectId");
            Node currentNode = publicationPanel.getCurrentNode();
            PublicationService publicationService = (PublicationService)publicationPanel.getApplicationComponent(PublicationService.class);
            WCMPublicationService wcmPublicationService = (WCMPublicationService)publicationPanel.getApplicationComponent(WCMPublicationService.class);
            PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get("Authoring publication");
            HashMap<String, String> context = new HashMap<String, String>();
            Node currentRevision = publicationPanel.getCurrentRevision();
            if (currentRevision != null) {
                context.put("Publication.context.currentVersion", currentRevision.getName());
            }
            try {
                if (currentNode.isLocked()) {
                    currentNode.getSession().addLockToken(LockUtil.getLockToken((Node)currentNode));
                }
                publicationPlugin.changeState(currentNode, state, context);
                currentNode.setProperty("publication:lastUser", event.getRequestContext().getRemoteUser());
                String nodeVersionUUID = null;
                String currentState = currentNode.getProperty("publication:currentState").getString();
                if ("published".equals(currentState) || "unpublished".equals(currentState)) {
                    if (currentNode.hasProperty("publication:liveRevision")) {
                        nodeVersionUUID = currentNode.getProperty("publication:liveRevision").getString();
                    }
                    if (nodeVersionUUID != null && !nodeVersionUUID.isEmpty()) {
                        publicationPanel.setCurrentRevision(publicationPanel.getRevisionByUUID(nodeVersionUUID));
                    }
                }
                String siteName = Util.getPortalRequestContext().getPortalOwner();
                String remoteUser = Util.getPortalRequestContext().getRemoteUser();
                wcmPublicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser, state);
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }
}

