/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.ext.impl.BaseKSActivity;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/forum/social-integration/plugin/space/PollUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})
public class PollUIActivity
extends BaseKSActivity {
    private String totalOfUsersVote;

    public Map<String, List<String>> getVotes() throws Exception {
        LinkedHashMap<String, List<String>> info = new LinkedHashMap<String, List<String>>();
        String pollId = this.getActivityParamValue("Id").replace(Utils.TOPIC, Utils.POLL);
        PollService pollService = (PollService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PollService.class);
        Poll poll = pollService.getPoll(pollId);
        String[] options = poll.getOption();
        String[] userVotes = poll.getUserVote();
        String[] votes = poll.getVote();
        int[] votesValues = this.getVotesOfOption(userVotes, options.length);
        for (int i = 0; i < options.length; ++i) {
            LinkedList<String> values = new LinkedList<String>();
            values.add(this.buildPercentVote(votes[i]));
            values.add(this.getStringFromNumberOfVotes(votesValues[i]));
            info.put(CommonUtils.decodeSpecialCharToHTMLnumber((String)options[i]), values);
        }
        this.setTotalUsersVotes(this.getStringFromNumberOfVotes(userVotes.length));
        return info;
    }

    private String buildPercentVote(String percent) {
        int index = percent.lastIndexOf(".");
        if (index > 0 && index + 2 < percent.length()) {
            percent = percent.substring(0, index + 3);
        }
        return percent;
    }

    public String getTotalUsersVotes() {
        return this.totalOfUsersVote;
    }

    public void setTotalUsersVotes(String totalOfUsersVote) {
        this.totalOfUsersVote = totalOfUsersVote;
    }

    private String getStringFromNumberOfVotes(int nbVotes) {
        if (nbVotes <= 1) {
            return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.vote").replace("{0}", String.valueOf(nbVotes));
        }
        return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.votes").replace("{0}", String.valueOf(nbVotes));
    }

    private int[] getVotesOfOption(String[] userVotes, int length) {
        int[] tab = new int[length];
        for (String userVote : userVotes) {
            String[] votes = userVote.split(":");
            for (int i = 1; i < votes.length; ++i) {
                int index = Integer.parseInt(votes[i]);
                tab[index] = 1;
            }
        }
        return tab;
    }

    private String getLink() {
        String spaceLink = this.getSpaceHomeURL(this.getSpaceGroupId());
        if (spaceLink == null) {
            return this.getActivityParamValue("PollLink");
        }
        String topicId = this.getActivityParamValue("Id");
        String topicLink = String.format("%s/forum/topic/%s", spaceLink, topicId);
        return topicLink;
    }

    private String getSpaceGroupId() {
        return this.getActivityParamValue("SpaceGroupId");
    }

    public String getSpaceHomeURL(String spaceGroupId) {
        if ("".equals(spaceGroupId)) {
            return null;
        }
        String permanentSpaceName = spaceGroupId.split("/")[2];
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(spaceGroupId);
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, space.getPrettyName());
        return nodeURL.setResource(resource).toString();
    }
}

