/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.service.search.SearchData;

public class TemplateSearchData
extends SearchData {
    private Log log = ExoLogger.getLogger(this.getClass());
    public static String TEMPLATE_PATH = "Preferences/TemplateContainer/%";
    public static String ALL_TEMPLATESPATH = "%/" + TEMPLATE_PATH;
    public static String PORTAL_TEMPLATESPATH = PORTAL_PATH + TEMPLATE_PATH;
    public static String GROUP_TEMPLATESPATH = GROUP_PATH + TEMPLATE_PATH;

    public TemplateSearchData(String title, String wikiType, String wikiOwner) {
        super(title, null, wikiType, wikiOwner, null);
        this.createJcrQueryPath();
    }

    public void createJcrQueryPath() {
        if (this.wikiType == null && this.wikiOwner == null) {
            this.jcrQueryPath = "jcr:path LIKE '" + ALL_TEMPLATESPATH + "'";
        }
        if (this.wikiType != null) {
            if (this.wikiType.equals(PortalConfig.USER_TYPE)) {
                this.jcrQueryPath = "jcr:path LIKE '" + this.USER_PATH + TEMPLATE_PATH + "'";
            } else {
                if (this.wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    this.jcrQueryPath = "jcr:path LIKE '" + PORTAL_TEMPLATESPATH + "'";
                } else if (this.wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    this.jcrQueryPath = "jcr:path LIKE '" + GROUP_TEMPLATESPATH + "'";
                }
                if (this.wikiOwner != null) {
                    this.jcrQueryPath = this.jcrQueryPath.replaceFirst("%", this.wikiOwner);
                }
            }
        }
    }

    @Override
    public String getStatementForSearchingTitle() {
        StringBuilder statement = new StringBuilder();
        try {
            String title = this.getTitle();
            statement.append("SELECT title, jcr:primaryType, path,description").append(" FROM ").append("wiki:page").append(" WHERE ");
            statement.append(this.jcrQueryPath);
            if (title != null && title.length() > 0) {
                statement.append(" AND ").append(" CONTAINS(title, '").append(title).append("') ");
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to get statement ", (Throwable)e);
        }
        return statement.toString();
    }
}

