/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.AbstractUrlBasedTicketValidator;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifierFactory;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Saml11TicketValidator
extends AbstractUrlBasedTicketValidator {
    private long tolerance = 1000L;

    public Saml11TicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    @Override
    protected String getUrlSuffix() {
        return "samlValidate";
    }

    @Override
    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
        String service = urlParameters.get("service");
        urlParameters.remove("service");
        urlParameters.remove("ticket");
        urlParameters.put("TARGET", service);
    }

    @Override
    protected void setDisableXmlSchemaValidation(boolean disabled) {
        if (disabled) {
            XML.parserPool.setDefaultSchemas(null, null);
        }
    }

    @Override
    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        try {
            String removeStartOfSoapBody = response.substring(response.indexOf("<SOAP-ENV:Body>") + 15);
            String removeEndOfSoapBody = removeStartOfSoapBody.substring(0, removeStartOfSoapBody.indexOf("</SOAP-ENV:Body>"));
            SAMLResponse samlResponse = new SAMLResponse((InputStream)new ByteArrayInputStream(CommonUtils.isNotBlank(this.getEncoding()) ? removeEndOfSoapBody.getBytes(Charset.forName(this.getEncoding())) : removeEndOfSoapBody.getBytes()));
            if (!samlResponse.getAssertions().hasNext()) {
                throw new TicketValidationException("No assertions found.");
            }
            Iterator iter = samlResponse.getAssertions();
            while (iter.hasNext()) {
                SAMLAssertion assertion = (SAMLAssertion)iter.next();
                if (!this.isValidAssertion(assertion)) continue;
                SAMLAuthenticationStatement authenticationStatement = this.getSAMLAuthenticationStatement(assertion);
                if (authenticationStatement == null) {
                    throw new TicketValidationException("No AuthentiationStatement found in SAML Assertion.");
                }
                SAMLSubject subject = authenticationStatement.getSubject();
                if (subject == null) {
                    throw new TicketValidationException("No Subject found in SAML Assertion.");
                }
                SAMLAttribute[] attributes = this.getAttributesFor(assertion, subject);
                HashMap<String, Object> personAttributes = new HashMap<String, Object>();
                for (SAMLAttribute samlAttribute : attributes) {
                    List<?> values = this.getValuesFrom(samlAttribute);
                    personAttributes.put(samlAttribute.getName(), values.size() == 1 ? values.get(0) : values);
                }
                AttributePrincipalImpl principal = new AttributePrincipalImpl(subject.getNameIdentifier().getName(), personAttributes);
                HashMap<String, Object> authenticationAttributes = new HashMap<String, Object>();
                authenticationAttributes.put("samlAuthenticationStatement::authMethod", authenticationStatement.getAuthMethod());
                return new AssertionImpl(principal, authenticationAttributes);
            }
        }
        catch (SAMLException e) {
            throw new TicketValidationException(e);
        }
        throw new TicketValidationException("No Assertion found within valid time range.  Either there's a replay of the ticket or there's clock drift. Check tolerance range, or server/client synchronization.");
    }

    private boolean isValidAssertion(SAMLAssertion assertion) {
        Date notBefore = assertion.getNotBefore();
        Date notOnOrAfter = assertion.getNotOnOrAfter();
        if (assertion.getNotBefore() == null || assertion.getNotOnOrAfter() == null) {
            this.log.debug((Object)"Assertion has no bounding dates. Will not process.");
            return false;
        }
        long currentTime = this.getCurrentTimeInUtc().getTime();
        if (currentTime + this.tolerance < notBefore.getTime()) {
            this.log.debug((Object)"skipping assertion that's not yet valid...");
            return false;
        }
        if (notOnOrAfter.getTime() <= currentTime - this.tolerance) {
            this.log.debug((Object)"skipping expired assertion...");
            return false;
        }
        return true;
    }

    private SAMLAuthenticationStatement getSAMLAuthenticationStatement(SAMLAssertion assertion) {
        Iterator iter = assertion.getStatements();
        while (iter.hasNext()) {
            SAMLStatement statement = (SAMLStatement)iter.next();
            if (!(statement instanceof SAMLAuthenticationStatement)) continue;
            return (SAMLAuthenticationStatement)statement;
        }
        return null;
    }

    private SAMLAttribute[] getAttributesFor(SAMLAssertion assertion, SAMLSubject subject) {
        ArrayList<SAMLAttribute> attributes = new ArrayList<SAMLAttribute>();
        Iterator iter = assertion.getStatements();
        while (iter.hasNext()) {
            SAMLStatement statement = (SAMLStatement)iter.next();
            if (!(statement instanceof SAMLAttributeStatement)) continue;
            SAMLAttributeStatement attributeStatement = (SAMLAttributeStatement)statement;
            if (!subject.getNameIdentifier().getName().equals(attributeStatement.getSubject().getNameIdentifier().getName())) continue;
            Iterator iter2 = attributeStatement.getAttributes();
            while (iter2.hasNext()) {
                attributes.add((SAMLAttribute)iter2.next());
            }
        }
        return attributes.toArray(new SAMLAttribute[attributes.size()]);
    }

    private List<?> getValuesFrom(SAMLAttribute attribute) {
        ArrayList list = new ArrayList();
        Iterator iter = attribute.getValues();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    private Date getCurrentTimeInUtc() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        return c.getTime();
    }

    @Override
    protected String retrieveResponseFromServer(URL validationUrl, String ticket) {
        String MESSAGE_TO_SEND;
        try {
            MESSAGE_TO_SEND = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><samlp:Request xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"  MajorVersion=\"1\" MinorVersion=\"1\" RequestID=\"" + SAMLIdentifierFactory.getInstance().getIdentifier() + "\" IssueInstant=\"" + CommonUtils.formatForUtcTime(new Date()) + "\">" + "<samlp:AssertionArtifact>" + ticket + "</samlp:AssertionArtifact></samlp:Request></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        }
        catch (SAMLException e) {
            throw new RuntimeException(e);
        }
        HttpURLConnection conn = null;
        try {
            String line;
            conn = (HttpURLConnection)validationUrl.openConnection();
            if (this.hostnameVerifier != null && conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
            }
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("Content-Length", Integer.toString(MESSAGE_TO_SEND.length()));
            conn.setRequestProperty("SOAPAction", "http://www.oasis-open.org/committees/security");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(MESSAGE_TO_SEND);
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(CommonUtils.isNotBlank(this.getEncoding()) ? new InputStreamReader(conn.getInputStream(), Charset.forName(this.getEncoding())) : new InputStreamReader(conn.getInputStream()));
            StringBuilder buffer = new StringBuilder(256);
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
    }
}

