/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.chm;

import java.util.ArrayList;
import java.util.Random;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.chm.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableConcurrentHashMap
extends ConcurrentHashMap<Object, Element> {
    private final Random rndm = new Random();

    public SelectableConcurrentHashMap(int initialCapacity, float loadFactor, int concurrency) {
        super(initialCapacity, loadFactor, concurrency);
    }

    public Element[] getRandomValues(int size) {
        int segmentStart;
        ArrayList<Element> sampled = new ArrayList<Element>(size);
        int randomHash = this.rndm.nextInt();
        int segmentIndex = segmentStart = randomHash >>> this.segmentShift & this.segmentMask;
        do {
            int tableStart;
            ConcurrentHashMap.HashEntry<K, V>[] table = this.segments[segmentIndex].table;
            int tableIndex = tableStart = randomHash & table.length - 1;
            do {
                ConcurrentHashMap.HashEntry e = table[tableIndex];
                while (e != null) {
                    Element value = (Element)e.value;
                    if (value != null) {
                        sampled.add(value);
                    }
                    e = e.next;
                }
                if (sampled.size() < size) continue;
                return sampled.toArray(new Element[sampled.size()]);
            } while ((tableIndex = tableIndex + 1 & table.length - 1) != tableStart);
        } while ((segmentIndex = segmentIndex + 1 & this.segmentMask) != segmentStart);
        return sampled.toArray(new Element[sampled.size()]);
    }
}

