/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form.validator;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class NodeTypeNameValidator
implements Validator {
    private static final String[] FILTER_CHARS = new String[]{"{", "/", "{", "[", "]", "|", "\"", "$", "(", ")", "?", "+", "\\", "^"};

    public void validate(UIFormInput uiInput) throws Exception {
        String inputValue = (String)uiInput.getValue();
        if (inputValue == null || inputValue.trim().length() == 0) {
            this.throwException("NodeTypeNameValidator.msg.empty-input", uiInput);
        }
        switch (inputValue.length()) {
            case 1: {
                this.checkOneChar(inputValue, uiInput);
                break;
            }
            case 2: {
                this.checkTwoChars(inputValue, uiInput);
            }
            default: {
                this.checkMoreChars(inputValue, uiInput);
            }
        }
    }

    private boolean checkArr(String s, String[] arrFilterChars) {
        for (String filter : arrFilterChars) {
            if (!s.equals(filter)) continue;
            return true;
        }
        return false;
    }

    private void checkOneChar(String s, UIFormInput uiInput) throws MessageException {
        if (this.checkArr(s, FILTER_CHARS)) {
            this.throwException("NodeTypeNameValidator.msg.Invalid-char", uiInput);
        }
    }

    private void checkTwoChars(String s, UIFormInput uiInput) throws MessageException {
        String s2 = "";
        if (s.startsWith(".")) {
            s2 = s.substring(1, 2);
            this.checkOneChar(s2, uiInput);
        } else if (s.endsWith(".")) {
            s2 = s.substring(0, 1);
            this.checkOneChar(s2, uiInput);
        } else {
            String s3 = s.substring(0, 1);
            String s4 = s.substring(1, 2);
            if (this.checkArr(s3, FILTER_CHARS)) {
                this.throwException("NodeTypeNameValidator.msg.Invalid-char", uiInput);
            } else if (this.checkArr(s4, FILTER_CHARS)) {
                this.throwException("NodeTypeNameValidator.msg.Invalid-char", uiInput);
            }
        }
    }

    private void checkMoreChars(String s, UIFormInput uiInput) throws MessageException {
        String s1 = s.substring(0, 1);
        String s2 = s.substring(s.length() - 1, s.length());
        if (this.checkArr(s1, FILTER_CHARS)) {
            this.throwException("NodeTypeNameValidator.msg.Invalid-char", uiInput);
        } else if (this.checkArr(s2, FILTER_CHARS)) {
            this.throwException("NodeTypeNameValidator.msg.Invalid-char", uiInput);
        } else {
            String s3 = s.substring(1, s.length() - 1);
            for (String filterChar : FILTER_CHARS) {
                if (s3.indexOf(filterChar) <= -1) continue;
                this.throwException("NodeTypeNameValidator.msg.Invalid-char", uiInput);
            }
        }
    }

    private void throwException(String s, UIFormInput uiInput) throws MessageException {
        throw new MessageException(new ApplicationMessage(s, null, 1));
    }
}

