/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.SerializationConstants;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.dataflow.serialization.SerializationSpoolFile;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public class PersistedValueDataReader {
    private final ReaderSpoolFileHolder holder;
    private final SpoolConfig spoolConfig;

    public PersistedValueDataReader(ReaderSpoolFileHolder holder, SpoolConfig spoolConfig) {
        this.holder = holder;
        this.spoolConfig = spoolConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistedValueData read(ObjectReader in, int type) throws UnknownClassIdException, IOException {
        StreamPersistedValueData streamPersistedValueData;
        File tempDirectory = new File(SerializationConstants.TEMP_DIR);
        PrivilegedFileHelper.mkdirs((File)tempDirectory);
        int key = in.readInt();
        if (key != 11) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        int orderNumber = in.readInt();
        boolean isByteArray = in.readBoolean();
        if (isByteArray) {
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            return ValueDataUtil.createValueData(type, orderNumber, data);
        }
        String id = in.readString();
        long length = in.readLong();
        SerializationSpoolFile sf = this.holder.get(id);
        if (sf == null) {
            if (length == -1L) {
                return new StreamPersistedValueData(orderNumber, (SpoolFile)null, this.spoolConfig);
            }
            sf = new SerializationSpoolFile(tempDirectory, id, this.holder);
            this.writeToFile(in, sf, length);
            this.holder.put(id, sf);
            return new StreamPersistedValueData(orderNumber, sf, this.spoolConfig);
        }
        sf.acquire(this);
        try {
            StreamPersistedValueData vd = new StreamPersistedValueData(orderNumber, sf, this.spoolConfig);
            if (in.skip(length) != length) {
                throw new IOException("Content isn't skipped correctly.");
            }
            streamPersistedValueData = vd;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            sf.release(this);
            throw throwable;
        }
        sf.release(this);
        return streamPersistedValueData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(ObjectReader src, SpoolFile dest, long length) throws IOException {
        FileOutputStream sfout = PrivilegedFileHelper.fileOutputStream((File)dest);
        int bSize = 2048;
        try {
            byte[] buff = new byte[bSize];
            while (length >= (long)bSize) {
                src.readFully(buff);
                sfout.write(buff);
                length -= (long)bSize;
            }
            if (length > 0L) {
                buff = new byte[(int)length];
                src.readFully(buff);
                sfout.write(buff);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            sfout.close();
            throw throwable;
        }
        sfout.close();
    }
}

