/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.impl.xml.exporting.HandlingContentExporter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DocumentViewContentExporter
extends HandlingContentExporter {
    private AttributesImpl currentAttr = null;
    protected String encoding;

    public DocumentViewContentExporter(ContentHandler handler, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(handler, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        try {
            if (node.getQPath().getName().equals((Object)Constants.JCR_XMLTEXT)) {
                List<PropertyData> nodeData = this.dataManager.getChildPropertiesData(node);
                String strValue = "";
                for (PropertyData propertyData : nodeData) {
                    if (!propertyData.getQPath().getName().equals((Object)Constants.JCR_XMLCHARACTERS)) continue;
                    strValue = ValueDataUtil.getString(propertyData.getValues().get(0));
                }
                this.contentHandler.characters(strValue.toCharArray(), 0, strValue.length());
            } else {
                List<PropertyData> nodeData = this.dataManager.getChildPropertiesData(node);
                this.currentAttr = new AttributesImpl();
                for (PropertyData property : nodeData) {
                    String strValue = "";
                    for (ValueData valueData : property.getValues()) {
                        String strVal = this.getValueAsStringForExport(valueData, property.getType());
                        if (strVal.equals("")) continue;
                        strValue = strValue + " " + (property.getType() == 2 ? strVal : StringConverter.normalizeString(strVal, true));
                    }
                    InternalQName internalPropName = ISO9075.encode(property.getQPath().getName());
                    this.currentAttr.addAttribute(internalPropName.getNamespace(), internalPropName.getName(), this.getExportName(property, true), "CDATA", !strValue.equals("") ? strValue.substring(1) : strValue);
                }
                if (Constants.ROOT_PATH.equals(node.getQPath())) {
                    this.contentHandler.startElement("http://www.jcp.org/jcr/1.0", "jcr", "jcr:root", this.currentAttr);
                } else {
                    this.contentHandler.startElement(node.getQPath().getName().getNamespace(), node.getQPath().getName().getName(), this.getExportName(node, true), this.currentAttr);
                }
            }
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        try {
            if (!node.getQPath().getName().equals((Object)Constants.JCR_XMLTEXT)) {
                if (Constants.ROOT_PATH.equals(node.getQPath())) {
                    this.contentHandler.endElement("http://www.jcp.org/jcr/1.0", "jcr", "jcr:root");
                } else {
                    this.contentHandler.endElement(node.getQPath().getName().getNamespace(), node.getQPath().getName().getName(), this.getExportName(node, true));
                }
            }
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }
}

