/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.BaseSecurityInfo;
import org.jboss.security.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditInfo
extends BaseSecurityInfo<AuditProviderEntry> {
    public AuditInfo(String name) {
        super(name);
    }

    public AuditProviderEntry[] getAuditProviderEntry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CONFIG_ENTRY_PERM);
        }
        AuditProviderEntry[] entries = new AuditProviderEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }

    @Override
    protected BaseSecurityInfo<AuditProviderEntry> create(String name) {
        return new AuditInfo(name);
    }

    public void writeContent(XMLStreamWriter writer) throws XMLStreamException {
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            AuditProviderEntry entry = (AuditProviderEntry)this.moduleEntries.get(i);
            writer.writeStartElement(Element.PROVIDER_MODULE.getLocalName());
            writer.writeAttribute(Attribute.CODE.getLocalName(), entry.getName());
            Map<String, Object> options = entry.getOptions();
            if (options != null && options.size() > 0) {
                for (Map.Entry<String, Object> option : options.entrySet()) {
                    writer.writeStartElement(Element.MODULE_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), option.getKey());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), option.getValue().toString());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

