/*
 * Decompiled with CFR 0.152.
 */
package org.josso;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.ComponentKeeper;
import org.josso.util.FactoryConfigurationError;

public abstract class ComponentKeeperFactory {
    private static final Log logger = LogFactory.getLog(ComponentKeeperFactory.class);
    public static final String COMPONENT_KEEKPER_FACTORY = "org.josso.ComponentKeeperFactory";
    private static String factoryClass = "org.josso.spring.SpringComponentKeeperFactoryImpl";
    private String _resourceFileName;

    public static ComponentKeeperFactory getInstance() {
        if (System.getProperty(COMPONENT_KEEKPER_FACTORY) != null) {
            factoryClass = System.getProperty(COMPONENT_KEEKPER_FACTORY);
        }
        try {
            return (ComponentKeeperFactory)Class.forName(factoryClass).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FactoryConfigurationError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new FactoryConfigurationError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)("Class not found : " + factoryClass));
            throw new FactoryConfigurationError((Throwable)e);
        }
    }

    public static void setFactory(String f) {
        factoryClass = f;
    }

    public static String getFactory() {
        return factoryClass;
    }

    public abstract ComponentKeeper newComponentKeeper();

    public String getResourceFileName() {
        return this._resourceFileName;
    }

    public void setResourceFileName(String resourceFileName) {
        this._resourceFileName = resourceFileName;
    }
}

