/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.idm.AbstractDAOImpl;
import org.exoplatform.services.organization.idm.IDMUserListAccess;
import org.exoplatform.services.organization.idm.IntegrationCache;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.idm.UserImpl;
import org.gatein.common.logging.LogLevel;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.api.model.SimpleUser;

public class UserDAOImpl
extends AbstractDAOImpl
implements UserHandler {
    private List<UserEventListener> listeners_ = new ArrayList<UserEventListener>(3);
    public static final String USER_PASSWORD = "password";
    public static final String USER_FIRST_NAME = "firstName";
    public static final String USER_LAST_NAME = "lastName";
    public static final String USER_DISPLAY_NAME = "displayName";
    public static final String USER_EMAIL = "email";
    public static final String USER_CREATED_DATE = "createdDate";
    public static final String USER_LAST_LOGIN_TIME = "lastLoginTime";
    public static final String USER_ORGANIZATION_ID = "organizationId";
    public static final Set<String> USER_NON_PROFILE_KEYS;
    public static final DateFormat dateFormat;

    public UserDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService idmService) {
        super(orgService, idmService);
    }

    public final List getUserEventListeners() {
        return this.listeners_;
    }

    public void addUserEventListener(UserEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeUserEventListener(UserEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "createUser", new Object[]{"user", user, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, true);
        }
        try {
            this.orgService.flush();
            session.getPersistenceManager().createUser(user.getUserName());
        }
        catch (IdentityException e) {
            this.handleException("Identity operation error: ", (Exception)((Object)e));
        }
        if (this.getIntegrationCache() != null) {
            this.getIntegrationCache().invalidateAll();
        }
        this.persistUserInfo(user, session);
        if (broadcast) {
            this.postSave(user, true);
        }
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "saveUser", new Object[]{"user", user, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        if (broadcast) {
            this.preSave(user, false);
        }
        this.persistUserInfo(user, session);
        if (broadcast) {
            this.postSave(user, false);
        }
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "removeUser", new Object[]{"userName", userName, "broadcast", broadcast});
        }
        IdentitySession session = this.service_.getIdentitySession();
        org.picketlink.idm.api.User foundUser = null;
        try {
            this.orgService.flush();
            foundUser = session.getPersistenceManager().findUser(userName);
        }
        catch (IdentityException e) {
            this.handleException("Cannot obtain user: " + userName + "; ", (Exception)((Object)e));
        }
        if (foundUser == null) {
            return null;
        }
        try {
            this.orgService.getMembershipHandler().removeMembershipByUser(userName, false);
            this.orgService.getUserProfileHandler().removeUserProfile(userName, false);
        }
        catch (Exception e) {
            this.handleException("Cannot cleanup user relationships: " + userName + "; ", e);
        }
        User exoUser = this.getPopulatedUser(userName, session);
        if (broadcast) {
            this.preDelete(exoUser);
        }
        try {
            session.getPersistenceManager().removeUser(foundUser, true);
        }
        catch (IdentityException e) {
            this.handleException("Cannot remove user: " + userName + "; ", (Exception)((Object)e));
        }
        if (this.getIntegrationCache() != null) {
            this.getIntegrationCache().invalidateAll();
        }
        if (broadcast) {
            this.postDelete(exoUser);
        }
        return exoUser;
    }

    public User findUserByName(String userName) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUserByName", new Object[]{"userName", userName});
        }
        IdentitySession session = this.service_.getIdentitySession();
        User user = this.getPopulatedUser(userName, session);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findUserByName", user);
        }
        return user;
    }

    public LazyPageList getUserPageList(int pageSize) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "getUserPagetList", new Object[]{"pageSize", pageSize});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        return new LazyPageList((ListAccess)new IDMUserListAccess(qb, pageSize, true), pageSize);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findAllUsers", null);
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        return new IDMUserListAccess(qb, 20, true);
    }

    public boolean authenticate(String username, String password) throws Exception {
        User user;
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "authenticate", new Object[]{"userName", username, USER_PASSWORD, "****"});
        }
        if ((user = this.findUserByName(username)) == null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "authenticate", false);
            }
            return false;
        }
        boolean authenticated = false;
        if (this.orgService.getConfiguration().isPasswordAsAttribute()) {
            authenticated = user.getPassword().equals(password);
        } else {
            try {
                this.orgService.flush();
                IdentitySession session = this.service_.getIdentitySession();
                org.picketlink.idm.api.User idmUser = session.getPersistenceManager().findUser(user.getUserName());
                authenticated = session.getAttributesManager().validatePassword(idmUser, password);
            }
            catch (Exception e) {
                this.handleException("Cannot authenticate user: " + username + "; ", e);
            }
        }
        if (authenticated) {
            UserImpl userImpl = (UserImpl)user;
            userImpl.setLastLoginTime(Calendar.getInstance().getTime());
            this.saveUser((User)userImpl, false);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "authenticate", authenticated);
        }
        return authenticated;
    }

    public LazyPageList findUsers(Query q) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsers", new Object[]{"q", q});
        }
        ListAccess<User> list = this.findUsersByQuery(q);
        return new LazyPageList(list, 20);
    }

    public ListAccess<User> findUsersByQuery(Query q) throws Exception {
        IDMUserListAccess list;
        IntegrationCache cache;
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsersByQuery", new Object[]{"q", q});
        }
        if (q.getUserName() == null && q.getEmail() != null && q.getFirstName() == null && q.getLastName() == null) {
            final User uniqueUser = this.findUserByEmail(q.getEmail());
            if (uniqueUser != null) {
                return new ListAccess<User>(){

                    public User[] load(int index, int length) throws Exception {
                        return new User[]{uniqueUser};
                    }

                    public int getSize() throws Exception {
                        return 1;
                    }
                };
            }
            if (!q.getEmail().contains("*")) {
                return new ListAccess<User>(){

                    public User[] load(int index, int length) throws Exception {
                        return new User[0];
                    }

                    public int getSize() throws Exception {
                        return 0;
                    }
                };
            }
        }
        if ((cache = this.getIntegrationCache()) != null && (list = cache.getGtnUserLazyPageList(this.getCacheNS(), q)) != null) {
            return list;
        }
        this.orgService.flush();
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        if (q.getUserName() != null) {
            qb.idFilter(q.getUserName());
        }
        if (q.getEmail() != null) {
            qb.attributeValuesFilter(USER_EMAIL, new String[]{q.getEmail()});
        }
        if (q.getFirstName() != null) {
            qb.attributeValuesFilter(USER_FIRST_NAME, new String[]{q.getFirstName()});
        }
        if (q.getLastName() != null) {
            qb.attributeValuesFilter(USER_LAST_NAME, new String[]{q.getLastName()});
        }
        list = q.getUserName() == null && q.getEmail() == null && q.getFirstName() == null && q.getLastName() == null ? new IDMUserListAccess(qb, 20, !this.countPaginatedUsers()) : new IDMUserListAccess(qb, 20, false);
        if (cache != null) {
            cache.putGtnUserLazyPageList(this.getCacheNS(), q, list);
        }
        return list;
    }

    public LazyPageList findUsersByGroup(String groupId) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsersByGroup", new Object[]{"groupId", groupId});
        }
        return new LazyPageList(this.findUsersByGroupId(groupId), 20);
    }

    public User findUserByEmail(String email) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUserByEmail", new Object[]{"findUserByEmail", email});
        }
        IdentitySession session = this.service_.getIdentitySession();
        org.picketlink.idm.api.User plUser = null;
        try {
            this.orgService.flush();
            plUser = session.getAttributesManager().findUserByUniqueAttribute(USER_EMAIL, (Object)email);
        }
        catch (IdentityException e) {
            this.handleException("Cannot find user by email: " + email + "; ", (Exception)((Object)e));
        }
        UserImpl user = null;
        if (plUser != null) {
            user = new UserImpl(plUser.getId());
            this.populateUser((User)user, session);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findUserByEmail", user);
        }
        return user;
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findUsersByGroupId", new Object[]{"groupId", groupId});
        }
        UserQueryBuilder qb = this.service_.getIdentitySession().createUserQueryBuilder();
        Group jbidGroup = null;
        try {
            jbidGroup = this.orgService.getJBIDMGroup(groupId);
        }
        catch (Exception e) {
            this.handleException("Cannot obtain group: " + groupId + "; ", e);
        }
        qb.addRelatedGroup(jbidGroup);
        return new IDMUserListAccess(qb, 20, false);
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners_) {
            listener.postDelete(user);
        }
    }

    public void persistUserInfo(User user, IdentitySession session) {
        this.orgService.flush();
        AttributesManager am = session.getAttributesManager();
        ArrayList<SimpleAttribute> attributes = new ArrayList<SimpleAttribute>();
        if (user.getCreatedDate() != null) {
            attributes.add(new SimpleAttribute(USER_CREATED_DATE, (Object)("" + user.getCreatedDate().getTime())));
        }
        if (user.getLastLoginTime() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_LOGIN_TIME, (Object)("" + user.getLastLoginTime().getTime())));
        }
        if (user.getEmail() != null) {
            attributes.add(new SimpleAttribute(USER_EMAIL, (Object)user.getEmail()));
        }
        if (user.getFirstName() != null) {
            attributes.add(new SimpleAttribute(USER_FIRST_NAME, (Object)user.getFirstName()));
        }
        if (user.getLastName() != null) {
            attributes.add(new SimpleAttribute(USER_LAST_NAME, (Object)user.getLastName()));
        }
        if (user instanceof UserImpl) {
            UserImpl userImpl = (UserImpl)user;
            if (userImpl.getDisplayName() != null) {
                attributes.add(new SimpleAttribute(USER_DISPLAY_NAME, (Object)((UserImpl)user).getDisplayName()));
            } else {
                this.removeDisplayNameIfNeeded(am, user);
            }
        } else {
            this.log.warn((Object)("User is of class " + user.getClass() + " which is not instanceof " + UserImpl.class));
        }
        if (user.getOrganizationId() != null) {
            attributes.add(new SimpleAttribute(USER_ORGANIZATION_ID, (Object)user.getOrganizationId()));
        }
        if (user.getPassword() != null) {
            if (this.orgService.getConfiguration().isPasswordAsAttribute()) {
                attributes.add(new SimpleAttribute(USER_PASSWORD, (Object)user.getPassword()));
            } else {
                try {
                    am.updatePassword(session.getPersistenceManager().findUser(user.getUserName()), user.getPassword());
                }
                catch (IdentityException e) {
                    this.handleException("Cannot update password: " + user.getUserName() + "; ", (Exception)((Object)e));
                }
            }
        }
        Attribute[] attrs = new Attribute[attributes.size()];
        attrs = attributes.toArray(attrs);
        try {
            am.updateAttributes(user.getUserName(), attrs);
        }
        catch (IdentityException e) {
            this.handleException("Cannot update attributes for user: " + user.getUserName() + "; ", (Exception)((Object)e));
        }
    }

    public User getPopulatedUser(String userName, IdentitySession session) throws Exception {
        org.picketlink.idm.api.User u = null;
        this.orgService.flush();
        try {
            u = session.getPersistenceManager().findUser(userName);
        }
        catch (IdentityException e) {
            this.handleException("Cannot obtain user: " + userName + "; ", (Exception)((Object)e));
        }
        if (u == null) {
            return null;
        }
        UserImpl user = new UserImpl(userName);
        this.populateUser((User)user, session);
        return user;
    }

    public void populateUser(User user, IdentitySession session) {
        this.orgService.flush();
        AttributesManager am = session.getAttributesManager();
        Map attrs = null;
        try {
            attrs = am.getAttributes((IdentityType)new SimpleUser(user.getUserName()));
        }
        catch (IdentityException e) {
            this.handleException("Cannot obtain attributes for user: " + user.getUserName() + "; ", (Exception)((Object)e));
        }
        if (attrs == null) {
            return;
        }
        if (attrs.containsKey(USER_CREATED_DATE)) {
            try {
                long date = Long.parseLong(((Attribute)attrs.get(USER_CREATED_DATE)).getValue().toString());
                user.setCreatedDate(new Date(date));
            }
            catch (NumberFormatException e) {
                try {
                    user.setCreatedDate(dateFormat.parse(((Attribute)attrs.get(USER_CREATED_DATE)).getValue().toString()));
                }
                catch (ParseException e2) {
                    this.log.error((Object)("Cannot parse the creation date for: " + user.getUserName()));
                }
            }
        }
        if (attrs.containsKey(USER_EMAIL)) {
            user.setEmail(((Attribute)attrs.get(USER_EMAIL)).getValue().toString());
        }
        if (attrs.containsKey(USER_FIRST_NAME)) {
            user.setFirstName(((Attribute)attrs.get(USER_FIRST_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_LAST_LOGIN_TIME)) {
            try {
                Object lastLoginValue;
                Long lastLoginMillis = null;
                Attribute lastLoginAttr = (Attribute)attrs.get(USER_LAST_LOGIN_TIME);
                if (lastLoginAttr != null && (lastLoginValue = lastLoginAttr.getValue()) != null) {
                    lastLoginMillis = Long.parseLong(lastLoginValue.toString());
                }
                if (lastLoginMillis != null) {
                    user.setLastLoginTime(new Date(lastLoginMillis));
                }
            }
            catch (NumberFormatException e) {
                try {
                    user.setLastLoginTime(dateFormat.parse(((Attribute)attrs.get(USER_LAST_LOGIN_TIME)).getValue().toString()));
                }
                catch (ParseException e2) {
                    this.log.error((Object)("Cannot parse the last login date for: " + user.getUserName()));
                }
            }
        }
        if (attrs.containsKey(USER_LAST_NAME)) {
            user.setLastName(((Attribute)attrs.get(USER_LAST_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_DISPLAY_NAME)) {
            user.setFullName(((Attribute)attrs.get(USER_DISPLAY_NAME)).getValue().toString());
        }
        if (attrs.containsKey(USER_ORGANIZATION_ID)) {
            user.setOrganizationId(((Attribute)attrs.get(USER_ORGANIZATION_ID)).getValue().toString());
        }
        if (attrs.containsKey(USER_PASSWORD)) {
            user.setPassword(((Attribute)attrs.get(USER_PASSWORD)).getValue().toString());
        }
    }

    public PicketLinkIDMOrganizationServiceImpl getOrgService() {
        return this.orgService;
    }

    private IntegrationCache getIntegrationCache() {
        return ((PicketLinkIDMServiceImpl)this.service_).getIntegrationCache();
    }

    private String getCacheNS() {
        return ((PicketLinkIDMServiceImpl)this.service_).getRealmName();
    }

    private void removeDisplayNameIfNeeded(AttributesManager am, User user) {
        try {
            Attribute attr = am.getAttribute(user.getUserName(), USER_DISPLAY_NAME);
            if (attr != null) {
                am.removeAttributes(user.getUserName(), new String[]{USER_DISPLAY_NAME});
            }
        }
        catch (IdentityException e) {
            this.handleException("Cannot remove displayName attribute of user: " + user.getUserName() + "; ", (Exception)((Object)e));
        }
    }

    private boolean countPaginatedUsers() {
        return this.orgService.getConfiguration().isCountPaginatedUsers();
    }

    static {
        dateFormat = DateFormat.getInstance();
        HashSet<String> keys = new HashSet<String>();
        keys.add(USER_PASSWORD);
        keys.add(USER_FIRST_NAME);
        keys.add(USER_LAST_NAME);
        keys.add(USER_DISPLAY_NAME);
        keys.add(USER_EMAIL);
        keys.add(USER_CREATED_DATE);
        keys.add(USER_LAST_LOGIN_TIME);
        keys.add(USER_ORGANIZATION_ID);
        USER_NON_PROFILE_KEYS = Collections.unmodifiableSet(keys);
    }
}

