/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.io.FileChunkMapper;
import org.infinispan.io.GridFile;

public class GridOutputStream
extends OutputStream {
    private int index;
    private int localIndex;
    private final byte[] currentBuffer;
    private int numberOfChunksWhenOpened;
    private FileChunkMapper fileChunkMapper;
    private GridFile file;

    GridOutputStream(GridFile file, boolean append, Cache<String, byte[]> cache) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
        this.file = file;
        this.index = append ? (int)file.length() : 0;
        this.localIndex = this.index % this.getChunkSize();
        this.currentBuffer = append && !this.isLastChunkFull() ? this.fetchLastChunk() : this.createEmptyChunk();
        this.numberOfChunksWhenOpened = this.getLastChunkNumber() + 1;
    }

    private byte[] createEmptyChunk() {
        return new byte[this.getChunkSize()];
    }

    private boolean isLastChunkFull() {
        long bytesRemainingInLastChunk = this.file.length() % (long)this.getChunkSize();
        return bytesRemainingInLastChunk == 0L;
    }

    private byte[] fetchLastChunk() {
        byte[] chunk = this.fileChunkMapper.fetchChunk(this.getLastChunkNumber());
        return this.createFullSizeCopy(chunk);
    }

    private byte[] createFullSizeCopy(byte[] val) {
        byte[] chunk = this.createEmptyChunk();
        if (val != null) {
            System.arraycopy(val, 0, chunk, 0, val.length);
        }
        return chunk;
    }

    private int getLastChunkNumber() {
        return this.getChunkNumber((int)this.file.length() - 1);
    }

    @Override
    public void write(int b) throws IOException {
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.flush();
            this.localIndex = 0;
        }
        this.currentBuffer[this.localIndex] = (byte)b;
        ++this.localIndex;
        ++this.index;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b != null) {
            this.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int bytesWritten = this.writeToChunk(b, off, len);
            off += bytesWritten;
            len -= bytesWritten;
        }
    }

    private int writeToChunk(byte[] b, int off, int len) throws IOException {
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.flush();
            this.localIndex = 0;
            remaining = this.getChunkSize();
        }
        int bytesToWrite = Math.min(remaining, len);
        System.arraycopy(b, off, this.currentBuffer, this.localIndex, bytesToWrite);
        this.localIndex += bytesToWrite;
        this.index += bytesToWrite;
        return bytesToWrite;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.removeExcessChunks();
        this.reset();
    }

    private void removeExcessChunks() {
        for (int i = this.getLastChunkNumber() + 1; i < this.numberOfChunksWhenOpened; ++i) {
            this.fileChunkMapper.removeChunk(i);
        }
    }

    @Override
    public void flush() throws IOException {
        this.storeChunk();
        this.file.setLength(this.index);
    }

    private void storeChunk() {
        this.fileChunkMapper.storeChunk(this.getChunkNumber(this.index - 1), this.currentBuffer, this.localIndex);
    }

    private int getBytesRemainingInChunk() {
        return this.getChunkSize() - this.localIndex;
    }

    private int getChunkNumber(int position) {
        return position / this.getChunkSize();
    }

    private void reset() {
        this.localIndex = 0;
        this.index = 0;
    }

    private int getChunkSize() {
        return this.fileChunkMapper.getChunkSize();
    }
}

