/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import javax.servlet.ServletRequest;

public class ServletRequestContext {
    private static ThreadLocal<String> authority = new ThreadLocal();
    private static ThreadLocal<String> fullAuthority = new ThreadLocal();

    public static void setRequestInfo(ServletRequest req) {
        String auth = req.getServerName() + ":" + req.getServerPort();
        String fullAuth = req.getScheme() + "://" + auth;
        authority.set(auth);
        fullAuthority.set(fullAuth);
        System.setProperty("authority", auth);
        System.setProperty("fullAuthority", fullAuth);
    }

    public static String getAuthority() {
        String retVal = authority.get();
        if (retVal == null && (retVal = System.getProperty("authority")) == null) {
            retVal = ServletRequestContext.getDefaultAuthority();
        }
        return retVal;
    }

    private static String getDefaultAuthority() {
        String retVal = System.getProperty("defaultAuthority");
        if (retVal == null) {
            retVal = ServletRequestContext.getServerHostname() + ":" + ServletRequestContext.getServerPort();
            System.setProperty("defaultAuthority", retVal);
        }
        return retVal;
    }

    public static String getFullAuthority() {
        String retVal = fullAuthority.get();
        if (retVal == null && (retVal = System.getProperty("fullAuthority")) == null) {
            retVal = ServletRequestContext.getDefaultFullAuthority();
        }
        return retVal;
    }

    private static String getDefaultFullAuthority() {
        String retVal = System.getProperty("defaultFullAuthority");
        if (retVal != null) {
            retVal = "http://" + ServletRequestContext.getServerHostname() + ":" + ServletRequestContext.getServerPort();
            System.setProperty("defaultFullAuthority", retVal);
        }
        return retVal;
    }

    private static String getServerPort() {
        return System.getProperty("shindig.port") != null ? System.getProperty("shindig.port") : (System.getProperty("jetty.port") != null ? System.getProperty("jetty.port") : "8080");
    }

    private static String getServerHostname() {
        return System.getProperty("shindig.host") != null ? System.getProperty("shindig.host") : (System.getProperty("jetty.host") != null ? System.getProperty("jetty.host") : "localhost");
    }
}

