/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.user;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobExecutionContext;

public class AutoPruneJob
extends MultiTenancyJob {
    private static Log LOG = ExoLogger.getLogger(AutoPruneJob.class);

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return AutoPruneTask.class;
    }

    public class AutoPruneTask
    extends MultiTenancyJob.MultiTenancyTask {
        public AutoPruneTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)AutoPruneJob.this, context, repoName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
            try {
                ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)this.context);
                String desc = this.context.getJobDetail().getDescription();
                ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
                repositoryService.setCurrentRepositoryName(this.context.getJobDetail().getJobDataMap().getString(Utils.CACHE_REPO_NAME));
                forumService.runPrune(desc);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("\n\nAuto prune has worked on " + desc + " forum"));
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("\n\n >>>>>> AutoPrune Job error" + e.getMessage()));
            }
            finally {
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            }
        }
    }
}

