/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ItemLocation {
    protected String repository;
    protected String workspace;
    protected String path;
    protected String uuid;
    protected boolean isSystemSession;

    public ItemLocation() {
    }

    public ItemLocation(String repository, String workspace, String path, String uuid, boolean isSystem) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
        this.uuid = uuid;
        this.isSystemSession = isSystem;
    }

    public ItemLocation(String repository, String workspace, String path, String uuid) {
        this(repository, workspace, path, uuid, false);
    }

    public ItemLocation(String repository, String workspace, String path) {
        this(repository, workspace, path, null, false);
    }

    public ItemLocation(ItemLocation itemLocation) {
        this(itemLocation.repository, itemLocation.workspace, itemLocation.path, itemLocation.uuid, itemLocation.isSystemSession);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setSystemSession(boolean value) {
        this.isSystemSession = value;
    }

    public boolean isSystemSession() {
        return this.isSystemSession;
    }

    public static final ItemLocation getItemLocationByItem(Item item) {
        Session session = null;
        try {
            session = item.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = item.getPath();
            String uuid = null;
            try {
                if (item instanceof Node) {
                    uuid = ((Node)item).getUUID();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean isSystemSession = IdentityConstants.SYSTEM.equals(session.getUserID());
            return new ItemLocation(repository, workspace, path, uuid, isSystemSession);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final Item getItemByLocation(ItemLocation itemLocation) {
        Session session = null;
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository();
            session = (itemLocation.isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider()).getSession(itemLocation.getWorkspace(), repository);
            if (itemLocation.getUUID() != null) {
                return session.getNodeByUUID(itemLocation.getUUID());
            }
            return session.getItem(itemLocation.getPath());
        }
        catch (PathNotFoundException pne) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

