/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.listener;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.DataStorageImpl;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalArtifactsService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class CreateLivePortalEventListener
extends Listener<DataStorageImpl, PortalConfig> {
    private static final Log LOG = ExoLogger.getLogger((String)CreateLivePortalEventListener.class.getName());
    private boolean autoCreatedDrive = true;
    private ArrayList<String> targetDrives = null;
    public static String AUTO_CREATE_DRIVE = "autoCreatedDrive";
    public static String TARGET_DRIVES = "targetDrives";

    public CreateLivePortalEventListener() {
    }

    public CreateLivePortalEventListener(InitParams params) throws Exception {
        if (params != null) {
            ValuesParam targets;
            ValueParam autoCreated = params.getValueParam(AUTO_CREATE_DRIVE);
            if (autoCreated != null) {
                this.autoCreatedDrive = Boolean.parseBoolean(autoCreated.getValue());
            }
            if ((targets = params.getValuesParam(TARGET_DRIVES)) != null) {
                this.targetDrives = targets.getValues();
            }
        }
    }

    public final void onEvent(Event<DataStorageImpl, PortalConfig> event) throws Exception {
        PortalConfig portalConfig = (PortalConfig)event.getData();
        if (!PortalConfig.PORTAL_TYPE.equals(portalConfig.getType())) {
            return;
        }
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            livePortalManagerService.getLivePortal(sessionProvider, portalConfig.getName());
            return;
        }
        catch (Exception e) {
            block14: {
                block13: {
                    block12: {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Creating new resource storage for portal: " + portalConfig.getName()));
                        }
                        try {
                            livePortalManagerService.addLivePortal(sessionProvider, portalConfig);
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("Created new resource storage for portal: " + portalConfig.getName()));
                            }
                        }
                        catch (Exception e2) {
                            if (!LOG.isErrorEnabled()) break block12;
                            LOG.error((Object)("Error when create new resource storage: " + portalConfig.getName()), (Throwable)e2);
                        }
                    }
                    if (this.autoCreatedDrive || !this.autoCreatedDrive && this.targetDrives != null && this.targetDrives.contains(portalConfig.getName())) {
                        ManageDriveService manageDriveService = WCMCoreUtils.getService(ManageDriveService.class);
                        WCMConfigurationService configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
                        try {
                            Node portal = livePortalManagerService.getLivePortal(sessionProvider, portalConfig.getName());
                            this.createPortalDrive(portal, portalConfig, configurationService, manageDriveService);
                        }
                        catch (Exception e3) {
                            if (!LOG.isErrorEnabled()) break block13;
                            LOG.error((Object)("Error when create drive for portal: " + portalConfig.getName()), (Throwable)e3);
                        }
                    }
                }
                CreatePortalArtifactsService artifactsInitializerService = WCMCoreUtils.getService(CreatePortalArtifactsService.class);
                try {
                    artifactsInitializerService.deployArtifactsToPortal(sessionProvider, portalConfig.getName(), portalConfig.getPortalLayout().getId());
                }
                catch (Exception e4) {
                    if (!LOG.isErrorEnabled()) break block14;
                    LOG.error((Object)("Error when create drive for portal: " + portalConfig.getName()), (Throwable)e4);
                }
            }
            return;
        }
    }

    private void createPortalDrive(Node portal, PortalConfig portalConfig, WCMConfigurationService wcmConfigService, ManageDriveService driveService) throws Exception {
        Session session = portal.getSession();
        String workspace = session.getWorkspace().getName();
        DriveData mainDriveData = wcmConfigService.getSiteDriveConfig();
        String permission = portalConfig.getEditPermission();
        String portalPath = portal.getPath();
        String homePath = mainDriveData.getHomePath();
        homePath = homePath.replaceAll("\\{siteName\\}", portal.getName());
        homePath = homePath.replaceAll("\\{sitePath\\}", portalPath);
        String views = mainDriveData.getViews();
        String icon = mainDriveData.getIcon();
        boolean viewReferences = mainDriveData.getViewPreferences();
        boolean viewNonDocument = mainDriveData.getViewNonDocument();
        boolean viewSideBar = mainDriveData.getViewSideBar();
        boolean showHiddenNode = mainDriveData.getShowHiddenNode();
        String allowCreateFolder = mainDriveData.getAllowCreateFolders();
        String allowNodeTypesOnTree = mainDriveData.getAllowNodeTypesOnTree();
        String driveName = String.format("%s-category", portal.getName());
        driveService.addDrive(driveName, workspace, permission, homePath, views, icon, viewReferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Create new drive for portal: " + portalConfig.getName()));
        }
    }
}

