/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexInfos;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.RSyncJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class RsyncIndexInfos
extends JBossCacheIndexInfos {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RsyncIndexInfos");
    private final String indexPath;
    private final String urlFormatString;
    private final String rsyncUserName;
    private final String rsyncPassword;

    public RsyncIndexInfos(Fqn<String> rootFqn, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler, String indexPath, int rsyncPort, String rsyncEntryName, String rsyncEntryPath, String rsyncUserName, String rsyncPassword) throws RepositoryConfigurationException {
        super(rootFqn, cache, system, modeHandler);
        String relativeIndexPath;
        String absoluteRsyncEntryPath;
        this.rsyncUserName = rsyncUserName;
        this.rsyncPassword = rsyncPassword;
        try {
            this.indexPath = new File(indexPath).getCanonicalPath();
            absoluteRsyncEntryPath = new File(rsyncEntryPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Index path or rsyncEntry path is invalid.", e);
        }
        if (this.indexPath.startsWith(absoluteRsyncEntryPath)) {
            relativeIndexPath = this.indexPath.substring(absoluteRsyncEntryPath.length());
            if (File.separatorChar == '\\') {
                relativeIndexPath = relativeIndexPath.replace(File.separatorChar, '/');
            }
        } else {
            throw new RepositoryConfigurationException("Invalid RSync configuration. Index must be placed in folder that is a descendant of RSync Server Entry. Current RSync Server Entry Path is : " + absoluteRsyncEntryPath + " but it doesnt hold Index folder, that is : " + this.indexPath + ". Please fix configuration according to JCR Documentation and restart application.");
        }
        this.urlFormatString = "rsync://%s:" + rsyncPort + "/" + rsyncEntryName + relativeIndexPath + "/";
    }

    @Override
    protected void refreshIndexes(Set<String> set) {
        this.triggerRSyncSynchronization();
        super.refreshIndexes(set);
    }

    @Override
    public void read() throws IOException {
        this.triggerRSyncSynchronization();
        super.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerRSyncSynchronization() {
        if (this.modeHandler.getMode() == IndexerIoMode.READ_ONLY && ((CacheSPI)this.cache).getRPCManager().getCoordinator() instanceof IpAddress) {
            String address = ((IpAddress)((CacheSPI)this.cache).getRPCManager().getCoordinator()).getIpAddress().getHostAddress();
            RSyncJob rSyncJob = new RSyncJob(String.format(this.urlFormatString, address), this.indexPath, this.rsyncUserName, this.rsyncPassword);
            try {
                RsyncIndexInfos rsyncIndexInfos = this;
                synchronized (rsyncIndexInfos) {
                    rSyncJob.execute();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to retrieve index using RSYNC", (Throwable)e);
            }
        }
    }
}

